/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.vesalainen.io.Rewindable;

public class RewindableInputStream
extends BufferedInputStream
implements Rewindable {
    protected int maxRewind;
    protected int lastReadCount;

    public RewindableInputStream(InputStream in, int maxRewind) {
        super(in);
        this.maxRewind = maxRewind;
    }

    public RewindableInputStream(InputStream in, int sz, int maxRewind) {
        super(in, sz);
        this.maxRewind = maxRewind;
    }

    @Override
    public void rewind(int count) throws IOException {
        if (count < 0 || count > this.maxRewind) {
            throw new IOException(count + " > maxRewind (=" + this.maxRewind + ")");
        }
        super.reset();
        super.skip(this.lastReadCount - count);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public synchronized void mark(int i) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public synchronized long skip(long l) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public synchronized int read(byte[] bytes, int off, int len) throws IOException {
        super.mark(this.maxRewind);
        this.lastReadCount = super.read(bytes, off, len);
        return this.lastReadCount;
    }

    @Override
    public synchronized int read() throws IOException {
        super.mark(this.maxRewind);
        this.lastReadCount = 1;
        return super.read();
    }
}

