/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.vesalainen.io.Rewindable;

public class RewindableReader
extends BufferedReader
implements Rewindable {
    protected int maxRewind;
    protected int lastReadCount;

    public RewindableReader(Reader reader, int sz, int maxRewind) {
        super(reader, sz);
        this.maxRewind = maxRewind;
    }

    public RewindableReader(Reader reader, int maxRewind) {
        super(reader);
        this.maxRewind = maxRewind;
    }

    @Override
    public void rewind(int count) throws IOException {
        if (count < 0 || count > this.maxRewind) {
            throw new IOException(count + " > maxRewind (=" + this.maxRewind + ")");
        }
        super.reset();
        super.skip(this.lastReadCount - count);
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void mark(int i) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public long skip(long l) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int read(char[] chars, int off, int len) throws IOException {
        super.mark(this.maxRewind);
        this.lastReadCount = super.read(chars, off, len);
        return this.lastReadCount;
    }

    @Override
    public int read() throws IOException {
        super.mark(this.maxRewind);
        this.lastReadCount = 1;
        return super.read();
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

