/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.lang;

import org.vesalainen.lang.NumberRanges;

public class Primitives {
    private static final int IntLimit = 0xCCCCCC2;
    private static final long LongLimit = 0xCCCCCCCCCCCCCC2L;

    public static char parseChar(CharSequence cs) {
        return Primitives.parseChar(cs, 0, cs.length());
    }

    public static char parseChar(CharSequence cs, int beginIndex, int endIndex) {
        if (endIndex - beginIndex != 1) {
            throw new IllegalArgumentException("input length must be 1");
        }
        return cs.charAt(beginIndex);
    }

    public static boolean parseBoolean(CharSequence cs) {
        return Primitives.parseBoolean(cs, 0, cs.length());
    }

    public static boolean parseBoolean(CharSequence cs, int beginIndex, int endIndex) {
        return endIndex - beginIndex == 4 && Character.codePointCount(cs, beginIndex, endIndex) == 4 && Character.toUpperCase(Character.codePointAt(cs, beginIndex)) == 84 && Character.toUpperCase(Character.codePointAt(cs, beginIndex + 1)) == 82 && Character.toUpperCase(Character.codePointAt(cs, beginIndex + 2)) == 85 && Character.toUpperCase(Character.codePointAt(cs, beginIndex + 3)) == 69;
    }

    public static boolean parseBoolean(CharSequence cs, int radix) {
        return Primitives.parseBoolean(cs, radix, 0, cs.length());
    }

    public static boolean parseBoolean(CharSequence cs, int radix, int beginIndex, int endIndex) {
        if (radix != 2) {
            throw new IllegalArgumentException("radix must be 2");
        }
        if (Character.codePointCount(cs, beginIndex, endIndex) != 1) {
            throw new IllegalArgumentException("input length must be 1");
        }
        int digit = Character.digit(Character.codePointAt(cs, beginIndex), 2);
        switch (digit) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        throw new IllegalArgumentException("input must be 0/1");
    }

    public static float parseFloat(CharSequence cs) {
        return Primitives.parseFloat(cs, 0, cs.length());
    }

    public static float parseFloat(CharSequence cs, int beginIndex, int endIndex) {
        FloatState fs = FloatState.Significand;
        int end = endIndex;
        int significand = 0;
        int sign = 1;
        int index = beginIndex;
        int decimal = 0;
        int exponent = 0;
        int exponentSign = 1;
        boolean overFlow = false;
        int cp = Character.codePointAt(cs, index);
        if (cp == 43) {
            ++index;
        }
        if (cp == 45) {
            sign = -1;
            ++index;
        }
        if (index >= end) {
            throw new NumberFormatException("unparsable number " + cs.subSequence(beginIndex, endIndex));
        }
        block11: while (index < end) {
            cp = Character.codePointAt(cs, index);
            index = Character.isBmpCodePoint(cp) ? ++index : (index += 2);
            switch (cp) {
                default: {
                    int digit = Character.digit(cp, 10);
                    if (digit != -1) {
                        if (!overFlow && significand > 0xCCCCCC2) {
                            overFlow = true;
                        }
                        switch (fs) {
                            case Significand: {
                                if (!overFlow) {
                                    significand *= 10;
                                    significand += digit;
                                    break;
                                }
                                ++decimal;
                                break;
                            }
                            case Decimal: {
                                if (overFlow) break;
                                significand *= 10;
                                significand += digit;
                                --decimal;
                                break;
                            }
                            case Exponent: {
                                exponent = 10 * exponent + digit;
                            }
                        }
                        continue block11;
                    }
                    throw new NumberFormatException("no float " + cs.subSequence(beginIndex, endIndex));
                }
                case 46: {
                    if (fs != FloatState.Significand) {
                        throw new NumberFormatException("cannot convert " + cs.subSequence(beginIndex, endIndex) + " to float");
                    }
                    fs = FloatState.Decimal;
                    continue block11;
                }
                case 69: 
                case 101: {
                    if (fs == FloatState.Exponent) {
                        throw new NumberFormatException("cannot convert " + cs.subSequence(beginIndex, endIndex) + " to float");
                    }
                    fs = FloatState.Exponent;
                    continue block11;
                }
                case 45: {
                    if (fs != FloatState.Exponent) {
                        throw new NumberFormatException("cannot convert " + cs.subSequence(beginIndex, endIndex) + " to float");
                    }
                    exponentSign = -1;
                    continue block11;
                }
                case 43: 
            }
            if (fs == FloatState.Exponent) continue;
            throw new NumberFormatException("cannot convert " + cs.subSequence(beginIndex, endIndex) + " to float");
        }
        return (float)((double)(sign * significand) * Math.pow(10.0, exponentSign * exponent + decimal));
    }

    public static double parseDouble(CharSequence cs) {
        return Primitives.parseDouble(cs, 0, cs.length());
    }

    public static double parseDouble(CharSequence cs, int beginIndex, int endIndex) {
        FloatState fs = FloatState.Significand;
        int end = endIndex;
        long significand = 0L;
        int sign = 1;
        int index = beginIndex;
        int decimal = 0;
        int exponent = 0;
        int exponentSign = 1;
        boolean overFlow = false;
        int cp = Character.codePointAt(cs, index);
        if (cp == 43) {
            ++index;
        }
        if (cp == 45) {
            sign = -1;
            ++index;
        }
        if (index >= end) {
            throw new NumberFormatException("unparsable number " + cs.subSequence(beginIndex, endIndex));
        }
        block11: while (index < end) {
            cp = Character.codePointAt(cs, index);
            index = Character.isBmpCodePoint(cp) ? ++index : (index += 2);
            switch (cp) {
                default: {
                    int digit = Character.digit(cp, 10);
                    if (digit != -1) {
                        if (!overFlow && significand > 0xCCCCCCCCCCCCCC2L) {
                            overFlow = true;
                        }
                        switch (fs) {
                            case Significand: {
                                if (!overFlow) {
                                    significand *= 10L;
                                    significand += (long)digit;
                                    break;
                                }
                                ++decimal;
                                break;
                            }
                            case Decimal: {
                                if (overFlow) break;
                                significand *= 10L;
                                significand += (long)digit;
                                --decimal;
                                break;
                            }
                            case Exponent: {
                                exponent = 10 * exponent + digit;
                            }
                        }
                        continue block11;
                    }
                    throw new NumberFormatException("no float " + cs.subSequence(beginIndex, endIndex));
                }
                case 46: {
                    if (fs != FloatState.Significand) {
                        throw new NumberFormatException("cannot convert " + cs.subSequence(beginIndex, endIndex) + " to float");
                    }
                    fs = FloatState.Decimal;
                    continue block11;
                }
                case 69: 
                case 101: {
                    if (fs == FloatState.Exponent) {
                        throw new NumberFormatException("cannot convert " + cs.subSequence(beginIndex, endIndex) + " to float");
                    }
                    fs = FloatState.Exponent;
                    continue block11;
                }
                case 45: {
                    if (fs != FloatState.Exponent) {
                        throw new NumberFormatException("cannot convert " + cs.subSequence(beginIndex, endIndex) + " to float");
                    }
                    exponentSign = -1;
                    continue block11;
                }
                case 43: 
            }
            if (fs == FloatState.Exponent) continue;
            throw new NumberFormatException("cannot convert " + cs.subSequence(beginIndex, endIndex) + " to float");
        }
        return (double)((long)sign * significand) * Math.pow(10.0, exponentSign * exponent + decimal);
    }

    public static int parseInt(CharSequence cs) {
        return Primitives.parseInt(cs, 10);
    }

    public static int parseInt(CharSequence cs, int radix) {
        return Primitives.parseInt(cs, radix, 0, cs.length());
    }

    public static int parseInt(CharSequence cs, int beginIndex, int endIndex) {
        return Primitives.parseInt(cs, 10, beginIndex, endIndex);
    }

    public static int parseInt(CharSequence cs, int radix, int beginIndex, int endIndex) {
        int size = 32;
        int end = endIndex;
        boolean twoComp = false;
        if (radix < 0) {
            twoComp = true;
            radix = -radix;
            Primitives.check(cs, size, beginIndex, endIndex);
        } else {
            Primitives.check(cs, radix, NumberRanges.IntRange, beginIndex, endIndex);
        }
        int result = 0;
        int sign = -1;
        int index = beginIndex;
        int cp = Character.codePointAt(cs, index);
        if (cp == 43) {
            if (twoComp) {
                throw new NumberFormatException("no signs for 2-complement " + cs.subSequence(beginIndex, endIndex));
            }
            ++index;
        }
        if (cp == 45) {
            if (twoComp) {
                throw new NumberFormatException("no signs for 2-complement " + cs.subSequence(beginIndex, endIndex));
            }
            sign = 1;
            ++index;
        }
        if (index >= end) {
            throw new NumberFormatException("unparsable number " + cs.subSequence(beginIndex, endIndex));
        }
        int count = Character.codePointCount(cs, index, end);
        if (count == size) {
            twoComp = false;
        }
        while (index < end) {
            result *= radix;
            cp = Character.codePointAt(cs, index);
            int digit = Character.digit(cp, radix);
            if (digit == -1) {
                throw new NumberFormatException("unparsable number " + cs.subSequence(beginIndex, endIndex));
            }
            result -= digit;
            if (Character.isBmpCodePoint(cp)) {
                ++index;
                continue;
            }
            index += 2;
        }
        if (!twoComp || -result < 1 << count - 1) {
            return sign * result;
        }
        return -result + (-1 << count);
    }

    public static long parseLong(CharSequence cs) {
        return Primitives.parseLong(cs, 10);
    }

    public static long parseLong(CharSequence cs, int radix) {
        return Primitives.parseLong(cs, radix, 0, cs.length());
    }

    public static long parseLong(CharSequence cs, int beginIndex, int endIndex) {
        return Primitives.parseLong(cs, 10, beginIndex, endIndex);
    }

    public static long parseLong(CharSequence cs, int radix, int beginIndex, int endIndex) {
        int size = 64;
        int end = endIndex;
        boolean twoComp = false;
        if (radix < 0) {
            twoComp = true;
            radix = -radix;
            Primitives.check(cs, size, beginIndex, endIndex);
        } else {
            Primitives.check(cs, radix, NumberRanges.LongRange, beginIndex, endIndex);
        }
        long result = 0L;
        int sign = -1;
        int index = beginIndex;
        int cp = Character.codePointAt(cs, index);
        if (cp == 43) {
            if (twoComp) {
                throw new NumberFormatException("no signs for 2-complement " + cs.subSequence(beginIndex, endIndex));
            }
            ++index;
        }
        if (cp == 45) {
            if (twoComp) {
                throw new NumberFormatException("no signs for 2-complement " + cs.subSequence(beginIndex, endIndex));
            }
            sign = 1;
            ++index;
        }
        if (index >= end) {
            throw new NumberFormatException("unparsable number " + cs.subSequence(beginIndex, endIndex));
        }
        int count = Character.codePointCount(cs, index, end);
        if (count == size) {
            twoComp = false;
        }
        while (index < end) {
            result *= (long)radix;
            cp = Character.codePointAt(cs, index);
            int digit = Character.digit(cp, radix);
            if (digit == -1) {
                throw new NumberFormatException("unparsable number " + cs.subSequence(beginIndex, endIndex));
            }
            result -= (long)digit;
            if (Character.isBmpCodePoint(cp)) {
                ++index;
                continue;
            }
            index += 2;
        }
        if (!twoComp || -result < (long)(1 << count - 1)) {
            return (long)sign * result;
        }
        return -result + (long)(-1 << count);
    }

    public static short parseShort(CharSequence cs) {
        return Primitives.parseShort(cs, 10);
    }

    public static short parseShort(CharSequence cs, int radix) {
        return Primitives.parseShort(cs, radix, 0, cs.length());
    }

    public static short parseShort(CharSequence cs, int beginIndex, int endIndex) {
        return Primitives.parseShort(cs, 10, beginIndex, endIndex);
    }

    public static short parseShort(CharSequence cs, int radix, int beginIndex, int endIndex) {
        int size = 16;
        int end = endIndex;
        boolean twoComp = false;
        if (radix < 0) {
            twoComp = true;
            radix = -radix;
            Primitives.check(cs, size, beginIndex, endIndex);
        } else {
            Primitives.check(cs, radix, NumberRanges.ShortRange, beginIndex, endIndex);
        }
        int result = 0;
        int sign = -1;
        int index = beginIndex;
        int cp = Character.codePointAt(cs, index);
        if (cp == 43) {
            if (twoComp) {
                throw new NumberFormatException("no signs for 2-complement " + cs.subSequence(beginIndex, endIndex));
            }
            ++index;
        }
        if (cp == 45) {
            if (twoComp) {
                throw new NumberFormatException("no signs for 2-complement " + cs.subSequence(beginIndex, endIndex));
            }
            sign = 1;
            ++index;
        }
        if (index >= end) {
            throw new NumberFormatException("unparsable number " + cs.subSequence(beginIndex, endIndex));
        }
        int count = Character.codePointCount(cs, index, end);
        if (count == size) {
            twoComp = false;
        }
        while (index < end) {
            result = (short)(result * radix);
            cp = Character.codePointAt(cs, index);
            int digit = Character.digit(cp, radix);
            if (digit == -1) {
                throw new NumberFormatException("unparsable number " + cs.subSequence(beginIndex, endIndex));
            }
            result = (short)(result - digit);
            if (Character.isBmpCodePoint(cp)) {
                ++index;
                continue;
            }
            index += 2;
        }
        if (!twoComp || -result < 1 << count - 1) {
            return (short)(sign * result);
        }
        return (short)(-result + (-1 << count));
    }

    public static byte parseByte(CharSequence cs) {
        return Primitives.parseByte(cs, 10);
    }

    public static byte parseByte(CharSequence cs, int radix) {
        return Primitives.parseByte(cs, radix, 0, cs.length());
    }

    public static byte parseByte(CharSequence cs, int beginIndex, int endIndex) {
        return Primitives.parseByte(cs, 10, beginIndex, endIndex);
    }

    public static byte parseByte(CharSequence cs, int radix, int beginIndex, int endIndex) {
        int size = 8;
        int end = endIndex;
        boolean twoComp = false;
        if (radix < 0) {
            twoComp = true;
            radix = -radix;
            Primitives.check(cs, size, beginIndex, endIndex);
        } else {
            Primitives.check(cs, radix, NumberRanges.ByteRange, beginIndex, endIndex);
        }
        int result = 0;
        int sign = -1;
        int index = beginIndex;
        int cp = Character.codePointAt(cs, index);
        if (cp == 43) {
            if (twoComp) {
                throw new NumberFormatException("no signs for 2-complement " + cs.subSequence(beginIndex, endIndex));
            }
            ++index;
        }
        if (cp == 45) {
            if (twoComp) {
                throw new NumberFormatException("no signs for 2-complement " + cs.subSequence(beginIndex, endIndex));
            }
            sign = 1;
            ++index;
        }
        if (index >= end) {
            throw new NumberFormatException("unparsable number " + cs.subSequence(beginIndex, endIndex));
        }
        int count = Character.codePointCount(cs, index, end);
        if (count == size) {
            twoComp = false;
        }
        while (index < end) {
            result = (short)(result * radix);
            cp = Character.codePointAt(cs, index);
            int digit = Character.digit(cp, radix);
            if (digit == -1) {
                throw new NumberFormatException("unparsable number " + cs.subSequence(beginIndex, endIndex));
            }
            result = (short)(result - digit);
            if (Character.isBmpCodePoint(cp)) {
                ++index;
                continue;
            }
            index += 2;
        }
        if (!twoComp || -result < 1 << count - 1) {
            return (byte)(sign * result);
        }
        return (byte)(-result + (-1 << count));
    }

    public static int parseUnsignedInt(CharSequence cs) {
        return Primitives.parseUnsignedInt(cs, 10);
    }

    public static int parseUnsignedInt(CharSequence cs, int radix) {
        return Primitives.parseUnsignedInt(cs, radix, 0, cs.length());
    }

    public static int parseUnsignedInt(CharSequence cs, int radix, int beginIndex, int endIndex) {
        Primitives.check(cs, radix, NumberRanges.UnsignedIntRange, beginIndex, endIndex);
        int end = endIndex;
        int result = 0;
        int index = beginIndex;
        int cp = Character.codePointAt(cs, index);
        if (cp == 43) {
            ++index;
        }
        if (index >= end) {
            throw new NumberFormatException("unparsable number " + cs.subSequence(beginIndex, endIndex));
        }
        while (index < end) {
            result *= radix;
            cp = Character.codePointAt(cs, index);
            int digit = Character.digit(cp, radix);
            if (digit == -1) {
                throw new NumberFormatException("unparsable number " + cs.subSequence(beginIndex, endIndex));
            }
            result += digit;
            if (Character.isBmpCodePoint(cp)) {
                ++index;
                continue;
            }
            index += 2;
        }
        return result;
    }

    private static void check(CharSequence cs, int radix, CharSequence[][] range, int beginIndex, int endIndex) {
        int count;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException(cs + " radix " + radix + " not supported");
        }
        CharSequence lower = range[radix][0];
        CharSequence upper = range[radix][1];
        int sign = 1;
        int index = beginIndex;
        int cp = Character.codePointAt(cs, index);
        if (cp == 43) {
            ++index;
        }
        if (cp == 45) {
            sign = -1;
            ++index;
        }
        cp = Character.codePointAt(cs, index);
        int digit = Character.digit(cp, radix);
        for (count = Character.codePointCount(cs, index, endIndex); digit == 0 && count > 1; --count) {
            index = Character.isBmpCodePoint(cp) ? ++index : (index += 2);
            cp = Character.codePointAt(cs, index);
            digit = Character.digit(cp, radix);
        }
        if (sign == -1) {
            if (Character.codePointAt(lower, 0) != 45) {
                throw new NumberFormatException(cs.subSequence(beginIndex, endIndex) + " not in range[" + lower + " - " + upper + "]");
            }
            if (count + 1 > lower.length()) {
                throw new NumberFormatException(cs.subSequence(beginIndex, endIndex) + " not in range[" + lower + " - " + upper + "]");
            }
            if (count + 1 == lower.length() && Primitives.isGreater(cs, radix, lower, beginIndex, endIndex)) {
                throw new NumberFormatException(cs.subSequence(beginIndex, endIndex) + " not in range[" + lower + " - " + upper + "]");
            }
        } else {
            if (count > upper.length()) {
                throw new NumberFormatException(cs.subSequence(beginIndex, endIndex) + " not in range[" + lower + " - " + upper + "]");
            }
            if (count == upper.length() && Primitives.isGreater(cs, radix, upper, beginIndex, endIndex)) {
                throw new NumberFormatException(cs.subSequence(beginIndex, endIndex) + " not in range[" + lower + " - " + upper + "]");
            }
        }
    }

    private static boolean isGreater(CharSequence cs, int radix, CharSequence range, int beginIndex, int endIndex) {
        int end = endIndex;
        int count = Character.codePointCount(cs, beginIndex, end);
        int ii = 0;
        int jj = 0;
        switch (cs.charAt(beginIndex)) {
            case '-': {
                ii = 1;
                jj = 1;
                break;
            }
            case '+': {
                ii = 1;
            }
        }
        while (ii < count) {
            int cp1 = Character.codePointAt(cs, jj);
            int d1 = Character.digit(cp1, radix);
            if (d1 == -1) {
                throw new NumberFormatException(cs.subSequence(beginIndex, endIndex) + "not valid number");
            }
            int cp2 = Character.codePointAt(range, ii);
            int d2 = Character.digit(cp2, radix);
            if (d1 > d2) {
                return true;
            }
            if (d1 < d2) {
                return false;
            }
            jj = Character.isBmpCodePoint(cp1) ? ++jj : (jj += 2);
            ++ii;
        }
        return false;
    }

    private static void check(CharSequence cs, int size, int beginIndex, int endIndex) {
        int index = beginIndex;
        int end = endIndex;
        int count = Character.codePointCount(cs, index, end);
        if (count > size) {
            throw new NumberFormatException(cs.subSequence(beginIndex, endIndex) + "not valid number");
        }
    }

    private static enum FloatState {
        Significand,
        Decimal,
        Exponent;

    }
}

