/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math;

import org.vesalainen.math.AbstractPoint;
import org.vesalainen.math.Line;
import org.vesalainen.math.Point;

public class AbstractLine
implements Line {
    protected double a;
    protected double slope;

    public AbstractLine(double slope, Point p) {
        this(slope, p.getX(), p.getY());
    }

    public AbstractLine(double slope, double x, double y) {
        this.set(slope, x, y);
    }

    public AbstractLine(Point p1, Point p2) {
        this(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public AbstractLine(double x1, double y1, double x2, double y2) {
        this.set(x1, y1, x2, y2);
    }

    public final void set(double slope, Point p) {
        this.set(slope, p.getX(), p.getY());
    }

    public final void set(double slope, double x, double y) {
        this.slope = slope;
        this.a = Double.isInfinite(slope) ? x : y - slope * x;
    }

    public final void set(Point p1, Point p2) {
        this.set(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public final void set(double x1, double y1, double x2, double y2) {
        if (x2 != x1) {
            this.slope = (y2 - y1) / (x2 - x1);
            this.a = y1 - this.slope * x1;
        } else {
            this.slope = Double.POSITIVE_INFINITY;
            this.a = x1;
        }
    }

    @Override
    public double getY(double x) {
        if (!Double.isInfinite(this.slope)) {
            return this.slope * x + this.a;
        }
        if (x == this.a) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.NaN;
    }

    @Override
    public double getA() {
        return this.a;
    }

    @Override
    public double getSlope() {
        return this.slope;
    }

    public static Point crossPoint(Line l1, Line l2) {
        return AbstractLine.crossPoint(l1, l2, null);
    }

    public static Point crossPoint(Line l1, Line l2, AbstractPoint p) {
        double y4;
        double y3;
        double x4;
        double x3;
        double y2;
        if (Double.isInfinite(l1.getSlope())) {
            if (Double.isInfinite(l2.getSlope())) {
                return null;
            }
            return AbstractLine.cyclePoint(p, l1.getA(), l2.getY(l1.getA()));
        }
        if (Double.isInfinite(l2.getSlope())) {
            return AbstractLine.cyclePoint(p, l2.getA(), l1.getY(l2.getA()));
        }
        double x1 = 0.0;
        double x2 = 10.0;
        double y1 = l1.getY(x1);
        double dd = AbstractLine.det(x1 - x2, y1 - (y2 = l1.getY(x2)), (x3 = 0.0) - (x4 = 10.0), (y3 = l2.getY(x3)) - (y4 = l2.getY(x4)));
        if (dd == 0.0) {
            return null;
        }
        double x1y1x2y2 = AbstractLine.det(x1, y1, x2, y2);
        double x3y3x4y4 = AbstractLine.det(x3, y3, x4, y4);
        double xu = AbstractLine.det(x1y1x2y2, x1 - x2, x3y3x4y4, x3 - x4);
        double yu = AbstractLine.det(x1y1x2y2, y1 - y2, x3y3x4y4, y3 - y4);
        return AbstractLine.cyclePoint(p, xu / dd, yu / dd);
    }

    private static Point cyclePoint(AbstractPoint p, double x, double y) {
        if (p == null) {
            return new AbstractPoint(x, y);
        }
        p.set(x, y);
        return p;
    }

    private static double det(double a11, double a12, double a21, double a22) {
        return a11 * a22 - a12 * a21;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (int)(Double.doubleToLongBits(this.a) ^ Double.doubleToLongBits(this.a) >>> 32);
        hash = 89 * hash + (int)(Double.doubleToLongBits(this.slope) ^ Double.doubleToLongBits(this.slope) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractLine other = (AbstractLine)obj;
        if (Double.doubleToLongBits(this.a) != Double.doubleToLongBits(other.a)) {
            return false;
        }
        return Double.doubleToLongBits(this.slope) == Double.doubleToLongBits(other.slope);
    }

    public String toString() {
        return "AbstractLine{a=" + this.a + ", slope=" + this.slope + '}';
    }
}

