/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.vesalainen.math.Point;

public class AbstractPoint
implements Point,
Serializable {
    private static final long serialVersionUID = 1L;
    protected double x;
    protected double y;
    protected static final XComparator xcomp = new XComparator();

    public AbstractPoint() {
    }

    public AbstractPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public AbstractPoint(Point point) {
        this.x = point.getX();
        this.y = point.getY();
    }

    @Override
    public double getX() {
        return this.x;
    }

    public void set(Point point) {
        this.set(point.getX(), point.getY());
    }

    public void set(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void add(double x, double y) {
        this.x += x;
        this.y += y;
    }

    public void mul(double x, double y) {
        this.x *= x;
        this.y *= y;
    }

    public void setX(double x) {
        this.x = x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public static final Point mul(double k, Point p) {
        return new AbstractPoint(k * p.getX(), k * p.getY());
    }

    public static final Point add(Point ... points) {
        AbstractPoint res = new AbstractPoint();
        for (Point pp : points) {
            res.x += pp.getX();
            res.y += pp.getY();
        }
        return res;
    }

    public static final Point subtract(Point p1, Point p2) {
        return new AbstractPoint(p1.getX() - p2.getX(), p1.getY() - p2.getY());
    }

    public static final double distance(Point p1, Point p2) {
        return Math.hypot(p1.getX() - p2.getX(), p1.getY() - p2.getY());
    }

    public static final double angle(Point p1, Point p2) {
        double bb;
        double aa = p2.getY() - p1.getY();
        double dd = Math.atan2(aa, bb = p2.getX() - p1.getX());
        if (dd < 0.0) {
            dd += Math.PI * 2;
        }
        return Math.toDegrees(dd);
    }

    public static final Point move(Point p, double radians, double distance) {
        return new AbstractPoint(p.getX() + distance * Math.cos(radians), p.getY() + distance * Math.sin(radians));
    }

    public double[] toArray() {
        return new double[]{this.x, this.y};
    }

    public static final double[] toArray(Point ... points) {
        double[] res = new double[2 * points.length];
        int idx = 0;
        for (Point pp : points) {
            res[idx++] = pp.getX();
            res[idx++] = pp.getY();
        }
        return res;
    }

    public static final double maxX(Point ... points) {
        double max = Double.MIN_VALUE;
        for (Point p : points) {
            max = Math.max(max, p.getX());
        }
        return max;
    }

    public static final double maxY(Point ... points) {
        double max = Double.MIN_VALUE;
        for (Point p : points) {
            max = Math.max(max, p.getY());
        }
        return max;
    }

    public static final double minX(Point ... points) {
        double min = Double.MAX_VALUE;
        for (Point p : points) {
            min = Math.min(min, p.getX());
        }
        return min;
    }

    public static final double minY(Point ... points) {
        double min = Double.MAX_VALUE;
        for (Point p : points) {
            min = Math.min(min, p.getY());
        }
        return min;
    }

    public static final double maxX(List<Point> points) {
        double max = Double.MIN_VALUE;
        for (Point p : points) {
            max = Math.max(max, p.getX());
        }
        return max;
    }

    public static final double maxY(List<Point> points) {
        double max = Double.MIN_VALUE;
        for (Point p : points) {
            max = Math.max(max, p.getY());
        }
        return max;
    }

    public static final double minX(List<Point> points) {
        double min = Double.MAX_VALUE;
        for (Point p : points) {
            min = Math.min(min, p.getX());
        }
        return min;
    }

    public static final double minY(List<Point> points) {
        double min = Double.MAX_VALUE;
        for (Point p : points) {
            min = Math.min(min, p.getY());
        }
        return min;
    }

    public static final Point[] midPoints(int count, Point p1, Point p2) {
        Point[] res = new Point[count];
        Point gap = AbstractPoint.subtract(p2, p1);
        Point leg = AbstractPoint.mul(1.0 / (double)(count + 1), gap);
        for (int ii = 0; ii < count; ++ii) {
            res[ii] = AbstractPoint.add(p1, AbstractPoint.mul(ii + 1, leg));
        }
        return res;
    }

    public static final int searchX(Point[] points, Point key) {
        return Arrays.binarySearch(points, key, xcomp);
    }

    public static final int searchX(List<Point> points, Point key) {
        return Collections.binarySearch(points, key, xcomp);
    }

    public static final void sortX(Point[] points) {
        Arrays.sort(points, xcomp);
    }

    public static final void sortX(List<Point> points) {
        Collections.sort(points, xcomp);
    }

    public static final int compareX(Point p1, Point p2) {
        return xcomp.compare(p1, p2);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPoint other = (AbstractPoint)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    public String toString() {
        return "AbstractPoint{x=" + this.x + ", y=" + this.y + '}';
    }

    private static class XComparator
    implements Comparator<Point> {
        private XComparator() {
        }

        @Override
        public int compare(Point p1, Point p2) {
            return Double.compare(p1.getX(), p2.getX());
        }
    }
}

