/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math;

import java.io.Serializable;
import org.vesalainen.math.AbstractCircle;
import org.vesalainen.math.Circle;
import org.vesalainen.math.Circles;
import org.vesalainen.math.Sector;
import org.vesalainen.util.navi.Angle;

public class AbstractSector
extends AbstractCircle
implements Sector,
Serializable {
    private static final long serialVersionUID = 1L;
    protected double leftAngle;
    protected double rightAngle;

    public AbstractSector(Circle circle) {
        super(circle);
    }

    public AbstractSector(Circle circle, double leftAngle, double rightAngle) {
        super(circle);
        this.leftAngle = leftAngle;
        this.rightAngle = rightAngle;
    }

    @Override
    public boolean isInside(double x, double y) {
        return super.isInside(x, y) && this.isInSector(x, y);
    }

    public boolean isInSector(double x, double y) {
        if (this.isCircle()) {
            return true;
        }
        double angle = Circles.angle(this, x, y);
        if (this.getAngle() <= Math.PI) {
            return Angle.clockwise(this.rightAngle, angle) && Angle.clockwise(angle, this.leftAngle);
        }
        return !Angle.clockwise(this.leftAngle, angle) || !Angle.clockwise(angle, this.rightAngle);
    }

    public double getLeftX() {
        return this.getX() + Math.cos(this.leftAngle) * this.getRadius();
    }

    public double getLeftY() {
        return this.getY() + Math.sin(this.leftAngle) * this.getRadius();
    }

    public double getRightX() {
        return this.getX() + Math.cos(this.rightAngle) * this.getRadius();
    }

    public double getRightY() {
        return this.getY() + Math.sin(this.rightAngle) * this.getRadius();
    }

    @Override
    public boolean isCircle() {
        return this.leftAngle == this.rightAngle;
    }

    @Override
    public double getAngle() {
        return Angle.normalizeToFullAngle(Angle.angleDiff(this.rightAngle, this.leftAngle));
    }

    @Override
    public double getLeftAngle() {
        return this.leftAngle;
    }

    public void setLeftAngle(double leftAngle) {
        this.leftAngle = leftAngle;
    }

    @Override
    public double getRightAngle() {
        return this.rightAngle;
    }

    public void setRightAngle(double rightAngle) {
        this.rightAngle = rightAngle;
    }

    public void makeCircle() {
        this.rightAngle = 0.0;
        this.leftAngle = 0.0;
    }
}

