/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math;

import java.io.Serializable;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;
import org.vesalainen.math.Circle;
import org.vesalainen.math.LevenbergMarquardt;
import org.vesalainen.math.Matrices;
import org.vesalainen.math.Point;

public class CircleFitter
implements LevenbergMarquardt.Function,
LevenbergMarquardt.JacobianFactory,
Circle,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final double Epsilon = 1.0E-10;
    private DenseMatrix64F di;
    private final DenseMatrix64F initCenter = new DenseMatrix64F(2, 1);
    private final double[] centerData;
    private final DenseMatrix64F zero;
    private final LevenbergMarquardt levenbergMarquardt;
    private double radius;
    private DenseMatrix64F points;

    public CircleFitter() {
        this.centerData = this.initCenter.data;
        this.zero = new DenseMatrix64F(1, 1);
        this.levenbergMarquardt = new LevenbergMarquardt(this, this);
    }

    public Circle fit(Point initPoint, DenseMatrix64F points) {
        this.initCenter.data[0] = initPoint.getX();
        this.initCenter.data[1] = initPoint.getY();
        this.radius = Double.NaN;
        this.fit(points);
        return this;
    }

    public Circle fit(DenseMatrix64F initPoint, DenseMatrix64F points) {
        this.initCenter.setReshape(initPoint);
        this.radius = Double.NaN;
        this.fit(points);
        return this;
    }

    public Circle fit(Circle initCircle, DenseMatrix64F points) {
        this.initCenter.data[0] = initCircle.getX();
        this.initCenter.data[1] = initCircle.getY();
        this.radius = initCircle.getRadius();
        this.fit(points);
        return this;
    }

    private void fit(DenseMatrix64F points) {
        this.points = points;
        this.radius = Double.NaN;
        if (this.zero.numRows != points.numRows) {
            this.zero.reshape(points.numRows, 1);
        }
        if (!this.levenbergMarquardt.optimize(this.initCenter, points, this.zero)) {
            throw new IllegalArgumentException("Fit failed");
        }
        this.initCenter.set((D1Matrix64F)this.levenbergMarquardt.getParameters());
    }

    public static void filterInnerPoints(DenseMatrix64F points, DenseMatrix64F center, int minLeft, double percent) {
        assert (points.numCols == 2);
        assert (center.numCols == 1);
        assert (center.numRows == 2);
        if (percent <= 0.0 || percent >= 1.0) {
            throw new IllegalArgumentException("percent " + percent + " is not between 0 & 1");
        }
        DistComp dc = new DistComp(center.data[0], center.data[1]);
        Matrices.sort(points, dc);
        int rows = points.numRows;
        double[] d = points.data;
        double limit = dc.distance(d[0], d[1]) * percent;
        for (int r = minLeft; r < rows; ++r) {
            double distance = dc.distance(d[2 * r], d[2 * r + 1]);
            if (!(distance < limit)) continue;
            points.reshape(r / 2, 2, true);
            break;
        }
    }

    public static void limitDistance(DenseMatrix64F p0, DenseMatrix64F pr, double min, double max) {
        double xr = pr.data[0];
        double x0 = p0.data[0];
        double dx = xr - x0;
        double yr = pr.data[1];
        double y0 = p0.data[1];
        double dy = yr - y0;
        double r = Math.sqrt(dx * dx + dy * dy);
        if (r < min || r > max) {
            r = r < min ? min : max;
            double m = dy / dx;
            if (Double.isInfinite(m)) {
                pr.data[1] = m > 0.0 ? y0 + r : y0 - r;
            } else {
                double x = Math.sqrt(r * r / (m * m + 1.0));
                double y = m * x;
                pr.data[0] = x0 + x;
                pr.data[1] = y0 + y;
            }
        }
    }

    public static double meanCenter(DenseMatrix64F points, DenseMatrix64F center) {
        assert (points.numCols == 2);
        assert (center.numCols == 1);
        assert (center.numRows == 2);
        center.zero();
        int count = points.numRows;
        double[] d = points.data;
        for (int i = 0; i < count; ++i) {
            center.add(0, 0, d[2 * i]);
            center.add(1, 0, d[2 * i + 1]);
        }
        if (count > 0) {
            CommonOps.divide((D1Matrix64F)center, (double)count);
            DenseMatrix64F di = new DenseMatrix64F(points.numRows, 1);
            CircleFitter.computeDi(center, points, di);
            return CommonOps.elementSum((D1Matrix64F)di) / (double)points.numRows;
        }
        return Double.NaN;
    }

    public static double initialCenter(DenseMatrix64F points, DenseMatrix64F center) {
        assert (points.numCols == 2);
        assert (center.numCols == 1);
        assert (center.numRows == 2);
        center.zero();
        int count = 0;
        int len1 = points.numRows;
        int len2 = len1 - 1;
        int len3 = len2 - 1;
        for (int i = 0; i < len3; ++i) {
            for (int j = i + 1; j < len2; ++j) {
                for (int k = j + 1; k < len1; ++k) {
                    if (!CircleFitter.center(points, i, j, k, center)) continue;
                    ++count;
                }
            }
        }
        if (count > 0) {
            CommonOps.divide((D1Matrix64F)center, (double)count);
            DenseMatrix64F di = new DenseMatrix64F(points.numRows, 1);
            CircleFitter.computeDi(center, points, di);
            return CommonOps.elementSum((D1Matrix64F)di) / (double)points.numRows;
        }
        return Double.NaN;
    }

    private static boolean center(DenseMatrix64F points, int i, int j, int k, DenseMatrix64F center) {
        double yk;
        double xi = points.get(i, 0);
        double yi = points.get(i, 1);
        double xj = points.get(j, 0);
        double yj = points.get(j, 1);
        double xk = points.get(k, 0);
        double det = (xk - xj) * (yj - yi) - (xj - xi) * ((yk = points.get(k, 1)) - yj);
        if (Math.abs(det) < 1.0E-10) {
            return false;
        }
        double det2 = 2.0 * det;
        double xyi2 = xi * xi + yi * yi;
        double xyj2 = xj * xj + yj * yj;
        double xyk2 = xk * xk + yk * yk;
        double x = ((yk - yj) * xyi2 + (yi - yk) * xyj2 + (yj - yi) * xyk2) / det2;
        double y = -((xk - xj) * xyi2 + (xi - xk) * xyj2 + (xj - xi) * xyk2) / det2;
        center.add(0, 0, x);
        center.add(1, 0, y);
        return true;
    }

    private void computeDi(DenseMatrix64F center, DenseMatrix64F points) {
        if (this.di == null) {
            this.di = new DenseMatrix64F(points.numRows, 1);
        } else if (this.di.numRows != points.numRows) {
            this.di.reshape(points.numRows, 1);
        }
        CircleFitter.computeDi(center, points, this.di);
    }

    private static void computeDi(DenseMatrix64F center, DenseMatrix64F points, DenseMatrix64F di) {
        double xx = center.get(0, 0);
        double yy = center.get(1, 0);
        for (int row = 0; row < points.numRows; ++row) {
            double xd = xx - points.get(row, 0);
            double yd = yy - points.get(row, 1);
            double r = Math.sqrt(xd * xd + yd * yd);
            di.set(row, 0, r);
        }
    }

    @Override
    public void compute(DenseMatrix64F center, DenseMatrix64F points, DenseMatrix64F y) {
        double r;
        if (Double.isNaN(this.radius)) {
            this.computeDi(center, points);
            r = CommonOps.elementSum((D1Matrix64F)this.di) / (double)points.numRows;
        } else {
            r = this.radius;
        }
        int len = points.numRows;
        double[] yd = y.data;
        double[] did = this.di.data;
        for (int row = 0; row < len; ++row) {
            yd[row] = did[row] - r;
        }
    }

    @Override
    public void computeJacobian(DenseMatrix64F param, DenseMatrix64F x, DenseMatrix64F jacobian) {
        this.computeDi(param, x);
        double xx = param.get(0, 0);
        double yy = param.get(1, 0);
        double sumXDk = 0.0;
        double sumYDk = 0.0;
        int n = x.numRows;
        for (int i = 0; i < n; ++i) {
            sumXDk += (xx - x.get(i, 0)) / this.di.data[i];
        }
        double xDk = sumXDk / (double)n;
        for (int i = 0; i < n; ++i) {
            sumYDk += (yy - x.get(i, 1)) / this.di.data[i];
        }
        double yDk = sumYDk / (double)n;
        for (int i = 0; i < n; ++i) {
            jacobian.set(0, i, (xx - x.get(i, 0)) / this.di.data[i] - xDk);
            jacobian.set(1, i, (yy - x.get(i, 1)) / this.di.data[i] - yDk);
        }
    }

    @Override
    public double getX() {
        return this.centerData[0];
    }

    @Override
    public double getY() {
        return this.centerData[1];
    }

    @Override
    public double getRadius() {
        if (Double.isNaN(this.radius)) {
            this.computeDi(this.initCenter, this.points);
            this.radius = CommonOps.elementSum((D1Matrix64F)this.di) / (double)this.points.numRows;
        }
        return this.radius;
    }

    public LevenbergMarquardt getLevenbergMarquardt() {
        return this.levenbergMarquardt;
    }

    private static class DistComp
    implements Matrices.RowComparator {
        private final double x;
        private final double y;

        public DistComp(double x, double y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public int compare(double[] data, int row, double[] pivot, int len) {
            double dp;
            double dd = this.distance(data[row * len], data[row * len + 1]);
            if (dd < (dp = this.distance(pivot[0], pivot[1]))) {
                return 1;
            }
            if (dd > dp) {
                return -1;
            }
            return 0;
        }

        private double distance(double xx, double yy) {
            double dx = this.x - xx;
            double dy = this.y - yy;
            return Math.sqrt(dx * dx + dy * dy);
        }
    }
}

