/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math;

import org.vesalainen.math.Circle;
import org.vesalainen.math.Point;
import org.vesalainen.util.navi.Angle;

public final class Circles {
    public static double angle(Circle circle, double x, double y) {
        return Circles.angle(circle.getX(), circle.getY(), x, y);
    }

    public static double angle(double x1, double y1, double x2, double y2) {
        return Angle.normalizeToFullAngle(Math.atan2(y2 - y1, x2 - x1));
    }

    public static boolean isInside(Circle circle, double x, double y) {
        return Circles.distanceFromCenter(circle, x, y) < circle.getRadius();
    }

    public static boolean isInside(Circle c1, Circle c2) {
        return Circles.distanceFromCenter(c1, c2.getX(), c2.getY()) + c2.getRadius() < c1.getRadius();
    }

    public static double distanceFromCenter(Point center, double x, double y) {
        return Math.hypot(x - center.getX(), y - center.getY());
    }

    public static double distance(Point p1, Point p2) {
        return Circles.distance(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.hypot(x1 - x2, y1 - y2);
    }
}

