/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math;

import org.ejml.data.DenseMatrix64F;
import org.vesalainen.math.Matrices;
import org.vesalainen.math.Point;
import org.vesalainen.math.Polygon;
import org.vesalainen.math.Vectors;

public class ConvexPolygon
extends Polygon {
    private static final long serialVersionUID = 1L;

    public ConvexPolygon() {
    }

    public ConvexPolygon(DenseMatrix64F points) {
        ConvexPolygon.updateConvexPolygon(this, points);
    }

    public void copy(ConvexPolygon oth) {
        super.copy(oth);
    }

    public boolean addPoint(double x, double y) {
        return ConvexPolygon.addPoint(this.points, x, y);
    }

    public static boolean addPoint(DenseMatrix64F points, double x, double y) {
        if (Matrices.containsRow(points, x, y)) {
            return false;
        }
        double[] d = points.data;
        switch (points.numRows) {
            case 0: 
            case 1: {
                Matrices.addRow(points, x, y);
                return true;
            }
            case 2: {
                if (Vectors.areAligned(d[0], d[1], d[2], d[3], x, y)) {
                    return ConvexPolygon.addAligned(points, x, y);
                }
                if (Vectors.isClockwise(d[0], d[1], d[2], d[3], x, y)) {
                    Matrices.insertRow(points, 1, x, y);
                } else {
                    Matrices.addRow(points, x, y);
                }
                return true;
            }
        }
        return ConvexPolygon.add(points, x, y);
    }

    public double getMinimumDistance(double x0, double y0) {
        double min = Double.MAX_VALUE;
        int rows = this.points.numRows;
        double[] d = this.points.data;
        double x1 = d[2 * (rows - 1)];
        double y1 = d[2 * (rows - 1) + 1];
        for (int r = 0; r < rows; ++r) {
            double x2 = d[2 * r];
            double y2 = d[2 * r + 1];
            min = Math.min(min, ConvexPolygon.distanceFromLine(x0, y0, x1, y1, x2, y2));
            x1 = x2;
            y1 = y2;
        }
        if (min > 0.0 && !this.isInside(x0, y0)) {
            throw new IllegalArgumentException("point not inside convex polygon");
        }
        return min;
    }

    public static double distanceFromLine(double x0, double y0, double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        if (dx == 0.0) {
            return Math.abs(x1 - x0);
        }
        double dy = y2 - y1;
        if (dy == 0.0) {
            return Math.abs(y1 - y0);
        }
        return Math.abs(dy * x0 - dx * y0 + x2 * y1 - y2 * x1) / Math.hypot(dx, dy);
    }

    public void getOuterBoundary(Point point, ConvexPolygon outer) {
        this.getOuterBoundary(point.getX(), point.getY(), outer);
    }

    public void getOuterBoundary(double x0, double y0, ConvexPolygon outer) {
        outer.copy(this);
        outer.addPoint(x0, y0);
        outer.removePoint(x0, y0);
    }

    public void getOuterBoundary(DenseMatrix64F point, DenseMatrix64F outer) {
        this.getOuterBoundary(point.data[0], point.data[1], outer);
    }

    public void getOuterBoundary(double x0, double y0, DenseMatrix64F outer) {
        double dyLeft;
        double dxLeft;
        int rows = this.points.numRows;
        if (rows < 3 || this.isInside(x0, y0)) {
            outer.setReshape(this.points);
            return;
        }
        double[] d = this.points.data;
        int left = 0;
        int right = 0;
        double x = d[0];
        double y = d[1];
        double dxRight = dxLeft = x - x0;
        double dyRight = dyLeft = y - y0;
        for (int r = 1; r < rows; ++r) {
            x = d[2 * r];
            double dx = x - x0;
            y = d[2 * r + 1];
            double dy = y - y0;
            if (Vectors.isCounterClockwise(dx, dy, dxLeft, dyLeft)) {
                dxLeft = dx;
                dyLeft = dy;
                left = r;
            }
            if (!Vectors.isClockwise(dx, dy, dxRight, dyRight)) continue;
            dxRight = dx;
            dyRight = dy;
            right = r;
        }
        if (left > right) {
            int count = left - right + 1;
            outer.reshape(count, 2);
            System.arraycopy(d, 2 * right, outer.data, 0, 2 * count);
        } else {
            outer.reshape(rows - (right - left) + 1, 2);
            System.arraycopy(d, 2 * right, outer.data, 0, 2 * (rows - right));
            System.arraycopy(d, 0, outer.data, 2 * (rows - right), 2 * (left + 1));
        }
    }

    public static ConvexPolygon createConvexPolygon(DenseMatrix64F points) {
        return ConvexPolygon.updateConvexPolygon(new ConvexPolygon(), points);
    }

    public void updateConvexPolygon(DenseMatrix64F points) {
        ConvexPolygon.updateConvexPolygon(this, points);
    }

    public static ConvexPolygon updateConvexPolygon(ConvexPolygon polygon, DenseMatrix64F points) {
        assert (points.numCols == 2);
        int rows = points.numRows;
        double[] d = points.data;
        for (int row = 0; row < rows; ++row) {
            polygon.addPoint(d[2 * row], d[2 * row + 1]);
        }
        return polygon;
    }

    public int getCount() {
        return this.points.numRows;
    }

    public boolean contains(double x, double y) {
        int rows = this.points.numRows;
        double[] d = this.points.data;
        for (int ii = 0; ii < rows; ++ii) {
            if (d[2 * ii] != x || d[2 * ii + 1] != y) continue;
            return true;
        }
        return false;
    }

    private static boolean addAligned(DenseMatrix64F m, double x, double y) {
        double[] d = m.data;
        if (d[0] != d[2]) {
            if (x < d[0] && x < d[2]) {
                if (d[0] < d[2]) {
                    d[0] = x;
                    d[1] = y;
                } else {
                    d[2] = x;
                    d[3] = y;
                }
                return true;
            }
            if (x > d[0] && x > d[2]) {
                if (d[0] > d[2]) {
                    d[0] = x;
                    d[1] = y;
                } else {
                    d[2] = x;
                    d[3] = y;
                }
                return true;
            }
        } else {
            if (y < d[1] && y < d[3]) {
                if (d[1] < d[3]) {
                    d[0] = x;
                    d[1] = y;
                } else {
                    d[2] = x;
                    d[3] = y;
                }
                return true;
            }
            if (y > d[1] && y > d[3]) {
                if (d[1] > d[3]) {
                    d[0] = x;
                    d[1] = y;
                } else {
                    d[2] = x;
                    d[3] = y;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean add(DenseMatrix64F m, double x, double y) {
        int len = m.numRows;
        double[] d = m.data;
        int ptr = 0;
        for (int ii = 0; ii < len; ++ii) {
            int next = (ii + 1) % len;
            if (Vectors.isClockwise(d[2 * ii], d[2 * ii + 1], d[2 * next], d[2 * next + 1], x, y)) continue;
            ptr = ii;
            break;
        }
        int start = -1;
        int end = -1;
        for (int cnt = 0; cnt < len; ++cnt) {
            int next = (ptr + 1) % len;
            if (Vectors.isClockwise(d[2 * (ptr = (ptr + 1) % len)], d[2 * ptr + 1], d[2 * next], d[2 * next + 1], x, y)) {
                if (start != -1) continue;
                start = ptr;
                continue;
            }
            if (start == -1) continue;
            end = ptr;
            break;
        }
        if (start != -1) {
            if ((start + 1) % len == end) {
                Matrices.insertRow(m, end, x, y);
            } else {
                int ii = (start + 1) % len;
                int c = 0;
                while (ii != end) {
                    d[2 * ii] = x;
                    d[2 * ii + 1] = y;
                    ii = (ii + 1) % len;
                    ++c;
                }
                if (c > 1) {
                    Matrices.removeEqualRows(m);
                }
            }
            return true;
        }
        return false;
    }

    private void removePoint(double x0, double y0) {
        Matrices.removeRow(this.points, x0, y0);
    }
}

