/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math;

import java.io.Serializable;
import org.vesalainen.math.AbstractPoint;
import org.vesalainen.math.Point;

public class CubicBezierCurve
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Point[] P;
    private int start;

    public CubicBezierCurve(double ... p) {
        this(CubicBezierCurve.makeArr(p));
    }

    public CubicBezierCurve(Point ... controlPoints) {
        if (controlPoints.length < 4) {
            throw new IllegalArgumentException("controlPoints length < 4");
        }
        this.P = controlPoints;
    }

    public CubicBezierCurve(int start, Point ... controlPoints) {
        if (controlPoints.length < start + 4) {
            throw new IllegalArgumentException("controlPoints length < 4");
        }
        this.P = controlPoints;
        this.start = start;
    }

    public Point eval(double t) {
        return this.eval(t, new AbstractPoint());
    }

    public Point eval(double t, AbstractPoint p) {
        if (t < 0.0 || t > 1.0) {
            throw new IllegalArgumentException("t=" + t + " not in [0,1]");
        }
        p.set(0.0, 0.0);
        double c0 = Math.pow(1.0 - t, 3.0);
        double c1 = 3.0 * Math.pow(1.0 - t, 2.0) * t;
        double c2 = 3.0 * (1.0 - t) * t * t;
        double c3 = t * t * t;
        p.add(c0 * this.P[this.start].getX(), c0 * this.P[this.start].getY());
        p.add(c1 * this.P[this.start + 1].getX(), c1 * this.P[this.start + 1].getY());
        p.add(c2 * this.P[this.start + 2].getX(), c2 * this.P[this.start + 2].getY());
        p.add(c3 * this.P[this.start + 3].getX(), c3 * this.P[this.start + 3].getY());
        return p;
    }

    private static Point[] makeArr(double ... p) {
        if (p.length != 8) {
            throw new IllegalArgumentException("4 controlPoints need 8 values");
        }
        Point[] cp = new Point[4];
        for (int ii = 0; ii < 4; ++ii) {
            cp[ii] = new AbstractPoint(p[2 * ii], p[2 * ii + 1]);
        }
        return cp;
    }

    public void curveStart() {
        double d0 = AbstractPoint.angle(this.P[this.start], this.P[this.start + 3]);
        double d1 = AbstractPoint.angle(this.P[this.start + 3], this.P[this.start]);
        double d2 = AbstractPoint.angle(this.P[this.start + 3], this.P[this.start + 2]);
        double a1 = d1 - d2;
        double a2 = d0 + a1;
        double di = AbstractPoint.distance(this.P[this.start + 3], this.P[this.start + 2]);
        this.P[this.start + 1] = AbstractPoint.move(this.P[this.start], a2, di);
    }

    public void curveEnd() {
        double d0 = AbstractPoint.angle(this.P[this.start], this.P[this.start + 3]);
        double d1 = AbstractPoint.angle(this.P[this.start + 3], this.P[this.start]);
        double d2 = AbstractPoint.angle(this.P[this.start], this.P[this.start + 1]);
        double a1 = d2 - d0;
        double a2 = d0 + a1;
        double di = AbstractPoint.distance(this.P[this.start], this.P[this.start + 1]);
        this.P[this.start + 2] = AbstractPoint.move(this.P[this.start + 3], a2, di);
    }
}

