/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math;

import java.io.Serializable;
import org.ejml.data.DenseMatrix64F;
import org.vesalainen.math.Matrices;
import org.vesalainen.math.Point;
import org.vesalainen.math.Rect;
import org.vesalainen.math.Vectors;

public class Polygon
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final DenseMatrix64F points;
    public final Rect bounds = new Rect();

    public Polygon() {
        this(new DenseMatrix64F(0, 2));
    }

    public Polygon(DenseMatrix64F points) {
        assert (points.numCols == 2);
        this.points = points;
        Matrices.removeEqualRows(points);
        this.updateBounds();
    }

    protected void copy(Polygon oth) {
        this.points.setReshape(oth.points);
        this.bounds.set(oth.bounds);
    }

    protected final void updateBounds() {
        this.bounds.reset();
        int len = this.points.numRows;
        double[] d = this.points.data;
        for (int ii = 0; ii < len; ++ii) {
            this.bounds.update(d[2 * ii], d[2 * ii + 1]);
        }
    }

    public boolean isInside(Point p) {
        return this.isInside(p.getX(), p.getY());
    }

    public boolean isInside(double testx, double testy) {
        if (!this.bounds.isInside(testx, testy)) {
            return false;
        }
        return Polygon.isRawHit(this.points, testx, testy);
    }

    public static boolean isRawHit(DenseMatrix64F points, double testx, double testy) {
        boolean c = false;
        int nvert = points.numRows;
        double[] d = points.data;
        int i = 0;
        int j = nvert - 1;
        while (i < nvert) {
            if (d[2 * i + 1] > testy != d[2 * j + 1] > testy && testx < (d[2 * j] - d[2 * i]) * (testy - d[2 * i + 1]) / (d[2 * j + 1] - d[2 * i + 1]) + d[2 * i]) {
                c = !c;
            }
            j = i++;
        }
        return c;
    }

    boolean isVertex(double x, double y) {
        int cnt = this.points.numRows;
        double[] d = this.points.data;
        for (int ii = 0; ii < cnt; ++ii) {
            if (x != d[2 * ii] || y != d[2 * ii + 1]) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.points.toString();
    }

    public boolean isConvex() {
        int rows = this.points.numRows;
        if (rows < 3) {
            return true;
        }
        double[] d = this.points.data;
        for (int i1 = 0; i1 < rows; ++i1) {
            double x1 = d[2 * i1];
            double y1 = d[2 * i1 + 1];
            int i2 = (i1 + 1) % rows;
            double x2 = d[2 * i2];
            double y2 = d[2 * i2 + 1];
            int i3 = (i2 + 1) % rows;
            double x3 = d[2 * i3];
            double y3 = d[2 * i3 + 1];
            if (!Vectors.isClockwise(x1, y1, x2, y2, x3, y3)) continue;
            return false;
        }
        return true;
    }
}

