/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math.sliding;

public abstract class AbstractSliding {
    protected int initialSize;
    protected int size;
    protected int begin;
    protected int end;

    protected AbstractSliding(int size) {
        this.initialSize = size;
        this.size = size;
    }

    public abstract void add(double var1);

    protected abstract void assign(int var1, double var2);

    protected abstract void remove(int var1);

    protected void eliminate() {
        for (int count = this.end - this.begin; count > 0 && this.isRemovable(this.begin % this.size); --count) {
            this.remove(this.begin % this.size);
            ++this.begin;
        }
    }

    protected abstract void grow();

    protected int newSize() {
        return Math.max(this.begin % this.size, this.initialSize) + this.size;
    }

    protected Object newArray(Object old, int oldLen, Object arr) {
        int sb = this.begin % oldLen;
        int se = this.end % oldLen;
        System.arraycopy(old, se, arr, se, oldLen - se);
        System.arraycopy(old, 0, arr, oldLen, sb);
        return arr;
    }

    protected abstract boolean isRemovable(int var1);
}

