/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math.sliding;

import org.vesalainen.math.sliding.AbstractSlidingAverage;

public abstract class AbstractSlidingAngleAverage
extends AbstractSlidingAverage {
    protected double[] cos;
    protected double[] sin;
    protected double cosSum;
    protected double sinSum;

    protected AbstractSlidingAngleAverage(int size) {
        super(size);
        this.cos = new double[size];
        this.sin = new double[size];
    }

    @Override
    public void add(double value) {
        if (value < 0.0 || value > 360.0) {
            throw new IllegalArgumentException(value + " not degree");
        }
        super.add(value);
    }

    @Override
    protected void assign(int index, double value) {
        double c;
        double s;
        double rad = Math.toRadians(value);
        this.sin[index] = s = Math.sin(rad);
        this.cos[index] = c = Math.cos(rad);
        this.sinSum += s;
        this.cosSum += c;
    }

    @Override
    protected void remove(int index) {
        this.sinSum -= this.sin[index];
        this.cosSum -= this.cos[index];
    }

    @Override
    public double fast() {
        int count = this.end - this.begin;
        return this.toDegrees(this.sinSum / (double)count, this.cosSum / (double)count);
    }

    @Override
    public double average() {
        int count = this.end - this.begin;
        double s = 0.0;
        double c = 0.0;
        for (int ii = this.begin; ii < this.end; ++ii) {
            s += this.sin[ii % this.size];
            c += this.cos[ii % this.size];
        }
        return this.toDegrees(s / (double)count, c / (double)count);
    }

    private double toDegrees(double y, double x) {
        double deg = Math.toDegrees(Math.atan2(y, x));
        if (deg < 0.0) {
            return 360.0 + deg;
        }
        return deg;
    }
}

