/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math.sliding;

import org.vesalainen.math.sliding.AbstractSliding;

public abstract class AbstractSlidingBound
extends AbstractSliding {
    protected double[] ring;

    public AbstractSlidingBound(int size) {
        super(size);
        this.ring = new double[size];
    }

    public double getBound() {
        return this.ring[this.begin % this.size];
    }

    @Override
    public void add(double value) {
        this.eliminate();
        this.assign(this.end % this.size, value);
        int e = this.end;
        while (e > this.begin && this.exceedsBounds(e, value)) {
            this.assign(--e % this.size, value);
        }
        ++this.end;
    }

    @Override
    protected void assign(int index, double value) {
        this.ring[index] = value;
    }

    @Override
    protected void remove(int index) {
    }

    @Override
    protected boolean isRemovable(int index) {
        return this.end - this.begin >= this.size;
    }

    @Override
    protected void grow() {
        int newSize = this.newSize();
        this.ring = (double[])this.newArray(this.ring, this.size, new double[newSize]);
        this.size = newSize;
    }

    protected abstract boolean exceedsBounds(int var1, double var2);
}

