/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math.sliding;

import org.vesalainen.math.sliding.AbstractSlidingBound;

public abstract class AbstractTimeoutSlidingBound
extends AbstractSlidingBound {
    protected final long timeout;
    protected long[] times;

    protected AbstractTimeoutSlidingBound(int size, long timeout) {
        super(size);
        this.timeout = timeout;
        this.times = new long[size];
    }

    @Override
    public void add(double value) {
        this.eliminate();
        if (this.end - this.begin >= this.size) {
            this.grow();
        }
        this.assign(this.end % this.size, value);
        while (this.end > this.begin && this.exceedsBounds(this.end, value)) {
            --this.end;
            this.assign(this.end % this.size, value);
        }
        ++this.end;
    }

    @Override
    protected void grow() {
        int newSize = this.newSize();
        this.ring = (double[])this.newArray(this.ring, this.size, new double[newSize]);
        this.times = (long[])this.newArray(this.times, this.times.length, new long[newSize]);
        this.size = newSize;
    }

    @Override
    protected void assign(int index, double value) {
        this.ring[index] = value;
        this.times[index] = System.currentTimeMillis();
    }

    @Override
    protected boolean isRemovable(int index) {
        return System.currentTimeMillis() - this.times[index] > this.timeout;
    }
}

