/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math.sliding;

import org.vesalainen.math.sliding.AbstractSlidingAverage;

public class SlidingAverage
extends AbstractSlidingAverage {
    protected double[] ring;
    protected double sum;

    public SlidingAverage(int size) {
        super(size);
        this.ring = new double[size];
    }

    @Override
    protected boolean isRemovable(int index) {
        return this.end - this.begin >= this.size;
    }

    @Override
    protected void assign(int index, double value) {
        this.ring[index] = value;
        this.sum += value;
    }

    @Override
    protected void remove(int index) {
        this.sum -= this.ring[index];
    }

    @Override
    public double fast() {
        return this.sum / (double)(this.end - this.begin);
    }

    @Override
    public double average() {
        double s = 0.0;
        for (int ii = this.begin; ii < this.end; ++ii) {
            s += this.ring[ii % this.size];
        }
        return s / (double)(this.end - this.begin);
    }

    @Override
    protected void grow() {
        int newSize = this.newSize();
        this.ring = (double[])this.newArray(this.ring, this.size, new double[newSize]);
        this.size = newSize;
    }
}

