/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math.sliding;

import org.vesalainen.math.sliding.AbstractSlidingAngleAverage;

public class TimeoutSlidingAngleAverage
extends AbstractSlidingAngleAverage {
    protected final long timeout;
    protected long[] times;

    public TimeoutSlidingAngleAverage(int size, long timeout) {
        super(size);
        this.timeout = timeout;
        this.times = new long[size];
    }

    @Override
    protected boolean isRemovable(int index) {
        return System.currentTimeMillis() - this.times[index] > this.timeout;
    }

    @Override
    protected void grow() {
        int newSize = this.newSize();
        this.sin = (double[])this.newArray(this.sin, this.size, new double[newSize]);
        this.cos = (double[])this.newArray(this.cos, this.size, new double[newSize]);
        this.times = (long[])this.newArray(this.times, this.times.length, new long[newSize]);
        this.size = newSize;
    }

    @Override
    protected void assign(int index, double value) {
        super.assign(index, value);
        this.times[index] = System.currentTimeMillis();
    }
}

