/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math.sliding;

import org.vesalainen.math.sliding.AbstractSlidingAverage;

public class TimeoutSlidingAverage
extends AbstractSlidingAverage {
    protected final long timeout;
    protected double[] ring;
    protected long[] times;
    protected double sum;

    public TimeoutSlidingAverage(int size, long timeout) {
        super(size);
        this.timeout = timeout;
        this.ring = new double[size];
        this.times = new long[size];
    }

    @Override
    protected boolean isRemovable(int index) {
        return System.currentTimeMillis() - this.times[index] > this.timeout;
    }

    @Override
    protected void grow() {
        int newSize = this.newSize();
        this.ring = (double[])this.newArray(this.ring, this.size, new double[newSize]);
        this.times = (long[])this.newArray(this.times, this.times.length, new long[newSize]);
        this.size = newSize;
    }

    @Override
    protected void assign(int index, double value) {
        this.ring[index] = value;
        this.sum += value;
        this.times[index] = System.currentTimeMillis();
    }

    @Override
    protected void remove(int index) {
        this.sum -= this.ring[index];
    }

    @Override
    public double fast() {
        return this.sum / (double)(this.end - this.begin);
    }

    @Override
    public double average() {
        double s = 0.0;
        for (int ii = this.begin; ii < this.end; ++ii) {
            s += this.ring[ii % this.size];
        }
        return s / (double)(this.end - this.begin);
    }
}

