/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.navi;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import org.vesalainen.navi.LocationSource;

public class AnchorageSimulator
extends TimerTask {
    private final URL url;
    private Timer timer;
    private LocationSource locationSource;
    private DataInputStream dis;

    public AnchorageSimulator() {
        this(null);
    }

    public AnchorageSimulator(Timer timer) {
        this.timer = timer;
        this.url = AnchorageSimulator.class.getResource("/simulation.ser");
        if (this.url == null) {
            throw new IllegalArgumentException("resource /simulation.ser not found");
        }
    }

    public void simulate(LocationSource locationSource, long period, boolean isDaemon) throws IOException {
        this.locationSource = locationSource;
        this.dis = new DataInputStream(new BufferedInputStream(this.url.openStream()));
        if (this.timer == null) {
            this.timer = new Timer("AnchorageSimulator", isDaemon);
        }
        this.timer.scheduleAtFixedRate((TimerTask)this, 0L, period);
    }

    @Override
    public void run() {
        try {
            float lon = this.dis.readFloat();
            float lat = this.dis.readFloat();
            this.locationSource.update(lon, lat, System.currentTimeMillis(), 1.0);
        }
        catch (EOFException ex) {
            this.cancel();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

