/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.navi;

import org.vesalainen.math.Unit;
import org.vesalainen.math.UnitType;

public class GreatCircle {
    private static final double R = 6371000.0;

    @Unit(value=UnitType.NM)
    public static final double distance(double lat1, double lon1, double lat2, double lon2) {
        double \u03c61 = Math.toRadians(lat1);
        double \u03c62 = Math.toRadians(lat2);
        double \u03bb1 = Math.toRadians(lon1);
        double \u03bb2 = Math.toRadians(lon2);
        double \u0394\u03c6 = \u03c62 - \u03c61;
        double \u0394\u03bb = \u03bb2 - \u03bb1;
        double a = Math.sin(\u0394\u03c6 / 2.0) * Math.sin(\u0394\u03c6 / 2.0) + Math.cos(\u03c61) * Math.cos(\u03c62) * Math.sin(\u0394\u03bb / 2.0) * Math.sin(\u0394\u03bb / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return UnitType.METER.convertTo(6371000.0 * c, UnitType.NM);
    }

    @Unit(value=UnitType.DEGREE)
    public static final double initialBearing(double lat1, double lon1, double lat2, double lon2) {
        double \u03c61 = Math.toRadians(lat1);
        double \u03c62 = Math.toRadians(lat2);
        double \u03bb1 = Math.toRadians(lon1);
        double \u03bb2 = Math.toRadians(lon2);
        double y = Math.sin(\u03bb2 - \u03bb1) * Math.cos(\u03c62);
        double x = Math.cos(\u03c61) * Math.sin(\u03c62) - Math.sin(\u03c61) * Math.cos(\u03c62) * Math.cos(\u03bb2 - \u03bb1);
        return Math.toDegrees(Math.atan2(y, x));
    }
}

