/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.navi;

import java.util.concurrent.TimeUnit;
import org.vesalainen.navi.WayPoint;

public class Navis {
    public static final double Kilo = 1000.0;
    public static final double NMInMeters = 1852.0;
    public static final double FeetInMeters = 0.3048;
    public static final double FathomInMeters = 1.8288;
    public static final double HoursInSeconds = TimeUnit.HOURS.toSeconds(1L);
    public static final double NMInMetersPerHoursInSecond = 1852.0 / HoursInSeconds;
    private static final double HoursInSecondPerKilo = HoursInSeconds / 1000.0;

    public static final double deltaLatitude(double distance, double bearing) {
        return Math.cos(Math.toRadians(bearing)) * distance / 60.0;
    }

    public static final double deltaLongitude(double latitude, double distance, double bearing) {
        double departure = Navis.departure(latitude);
        double sin = Math.sin(Math.toRadians(bearing));
        return sin * distance / (60.0 * departure);
    }

    public static final double departure(WayPoint loc1, WayPoint loc2) {
        return Navis.departure(loc2.getLatitude(), loc1.getLatitude());
    }

    public static final double departure(double latitude1, double latitude2) {
        Navis.checkLatitude(latitude1);
        Navis.checkLatitude(latitude2);
        return Navis.departure((latitude1 + latitude2) / 2.0);
    }

    public static final double departure(double latitude) {
        Navis.checkLatitude(latitude);
        return Math.cos(Math.toRadians(latitude));
    }

    public static final double bearing(WayPoint wp1, WayPoint wp2) {
        double lat1 = wp1.getLatitude();
        double lat2 = wp2.getLatitude();
        double lon1 = wp1.getLongitude();
        double lon2 = wp2.getLongitude();
        return Navis.bearing(lat1, lon1, lat2, lon2);
    }

    public static final double bearing(double lat1, double lon1, double lat2, double lon2) {
        return Math.toDegrees(Navis.radBearing(lat1, lon1, lat2, lon2));
    }

    public static final double radBearing(double lat1, double lon1, double lat2, double lon2) {
        Navis.checkLatitude(lat1);
        Navis.checkLongitude(lon1);
        Navis.checkLatitude(lat2);
        Navis.checkLongitude(lon2);
        double dep = Navis.departure(lat1, lat2);
        double aa = dep * (lon2 - lon1);
        double bb = lat2 - lat1;
        double dd = Math.atan2(aa, bb);
        if (dd < 0.0) {
            dd += Math.PI * 2;
        }
        return dd;
    }

    public static final double distance(WayPoint wp1, WayPoint wp2) {
        double lat1 = wp1.getLatitude();
        double lat2 = wp2.getLatitude();
        double lon1 = wp1.getLongitude();
        double lon2 = wp2.getLongitude();
        return Navis.distance(lat1, lon1, lat2, lon2);
    }

    public static final double distance(double lat1, double lon1, double lat2, double lon2) {
        Navis.checkLatitude(lat1);
        Navis.checkLongitude(lon1);
        Navis.checkLatitude(lat2);
        Navis.checkLongitude(lon2);
        double dep = Navis.departure(lat1, lat2);
        return 60.0 * Math.hypot(lat1 - lat2, dep * (lon1 - lon2));
    }

    public static final double speed(WayPoint wp1, WayPoint wp2) {
        double lat1 = wp1.getLatitude();
        double lat2 = wp2.getLatitude();
        double lon1 = wp1.getLongitude();
        double lon2 = wp2.getLongitude();
        long time1 = wp1.getTime();
        long time2 = wp2.getTime();
        return Navis.speed(time1, lat1, lon1, time2, lat2, lon2);
    }

    public static final double speed(long time1, double lat1, double lon1, long time2, double lat2, double lon2) {
        Navis.checkLatitude(lat1);
        Navis.checkLongitude(lon1);
        Navis.checkLatitude(lat2);
        Navis.checkLongitude(lon2);
        double distance = Navis.distance(lat1, lon1, lat2, lon2);
        double duration = time2 - time1;
        double hours = duration / 3600000.0;
        double speed = distance / hours;
        return speed;
    }

    public static final double addLongitude(double longitude, double delta) {
        double gha = Navis.longitudeToGHA(longitude);
        return Navis.ghaToLongitude(Navis.normalizeAngle(gha -= delta));
    }

    public static final double longitudeToGHA(double longitude) {
        if (longitude < 0.0) {
            return -longitude;
        }
        return 360.0 - longitude;
    }

    public static final double ghaToLongitude(double gha) {
        if (gha < 180.0) {
            return -gha;
        }
        return 360.0 - gha;
    }

    public static final double normalizeAngle(double deg) {
        if (deg < 0.0) {
            deg %= 360.0;
            deg += 360.0;
        }
        return deg % 360.0;
    }

    public static final double fathomsToMeters(double fathom) {
        return fathom * 1.8288;
    }

    public static final double metersToFathoms(double meters) {
        return meters / 1.8288;
    }

    public static final double feetsToMeters(double feets) {
        return feets * 0.3048;
    }

    public static final double metersToFeets(double meters) {
        return meters / 0.3048;
    }

    public static final double knotsToMetersPerSecond(double knots) {
        return NMInMetersPerHoursInSecond * knots;
    }

    public static final double metersPerSecondToKnots(double ms) {
        return NMInMetersPerHoursInSecond / ms;
    }

    public static final double metersPerSecondToKiloMetersInHour(double metersPerSecond) {
        return HoursInSecondPerKilo * metersPerSecond;
    }

    public static final double kiloMetersInHourToMetersPerSecond(double kmh) {
        return kmh / HoursInSecondPerKilo;
    }

    private static void checkLatitude(double latitude) {
        if (latitude > 90.0 || latitude < -90.0) {
            throw new IllegalArgumentException("latitude out of range " + latitude);
        }
    }

    private static void checkLongitude(double longitude) {
        if (longitude > 180.0 || longitude < -180.0) {
            throw new IllegalArgumentException("longitude out of range " + longitude);
        }
    }
}

