/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.navi;

import java.io.Serializable;
import org.vesalainen.math.AbstractCircle;
import org.vesalainen.math.AbstractPoint;
import org.vesalainen.math.Circle;
import org.vesalainen.math.Circles;
import org.vesalainen.math.Point;
import org.vesalainen.math.Sector;
import org.vesalainen.math.Vectors;
import org.vesalainen.util.navi.Angle;

public class SafeSector
implements Sector,
Serializable {
    private static final long serialVersionUID = 1L;
    private final InnerCircle innerCircle;
    private Point point;
    private final AbstractCircle attachCircle;
    private AbstractPoint detachPoint;
    private double innerRadius;
    private double rightX;
    private double rightY;
    private double leftX;
    private double leftY;

    public SafeSector(AbstractCircle circle) {
        this.attachCircle = circle;
        this.point = this.attachCircle;
        this.innerCircle = new InnerCircle();
        this.innerRadius = circle.getRadius() / 2.0;
    }

    @Override
    public double getAngle() {
        return Angle.normalizeToFullAngle(Angle.angleDiff(this.getRightAngle(), this.getLeftAngle()));
    }

    @Override
    public double getLeftAngle() {
        return Angle.normalizeToFullAngle(Math.atan2(this.leftY, this.leftX));
    }

    @Override
    public double getRightAngle() {
        return Angle.normalizeToFullAngle(Math.atan2(this.rightY, this.rightX));
    }

    private void updateSector() {
        this.setLeftAngle(this.getLeftAngle());
        this.setRightAngle(this.getRightAngle());
    }

    public void setLeftAngle(double radians) {
        double radius = this.getRadius();
        this.leftX = radius * Math.cos(radians);
        this.leftY = radius * Math.sin(radians);
    }

    public void setRightAngle(double radians) {
        double radius = this.getRadius();
        this.rightX = radius * Math.cos(radians);
        this.rightY = radius * Math.sin(radians);
    }

    @Override
    public boolean isCircle() {
        return Double.compare(this.leftX, this.rightX) == 0 && Double.compare(this.leftY, this.rightY) == 0;
    }

    @Override
    public double getRadius() {
        return this.attachCircle.getRadius();
    }

    private void setRadius(double r) {
        this.attachCircle.setRadius(r);
        this.updateSector();
    }

    public Circle getInnerCircle() {
        return this.innerCircle;
    }

    @Override
    public double getX() {
        return this.point.getX();
    }

    @Override
    public double getY() {
        return this.point.getY();
    }

    void set(double x, double y) {
        if (this.detachPoint == null) {
            this.detachPoint = new AbstractPoint(this.attachCircle);
            this.point = this.detachPoint;
        }
        this.detachPoint.set(x, y);
    }

    public boolean isInside(double x, double y) {
        if (this.isCircle()) {
            return Circles.isInside(this, x, y);
        }
        return Circles.isInside(this, x, y) && this.isInSector(x, y) || Circles.isInside(this.innerCircle, x, y);
    }

    public boolean isInSector(double x, double y) {
        if (this.isCircle()) {
            return true;
        }
        return this.rawIsInSector(x, y);
    }

    private boolean rawIsInSector(double x, double y) {
        double ox = x - this.getX();
        double oy = y - this.getY();
        if (Vectors.isClockwise(this.leftX, this.leftY, this.rightX, this.rightY)) {
            return Vectors.isClockwise(this.leftX, this.leftY, ox, oy) && Vectors.isClockwise(ox, oy, this.rightX, this.rightY);
        }
        return !Vectors.isClockwise(this.rightX, this.rightY, ox, oy) || !Vectors.isClockwise(ox, oy, this.leftX, this.leftY);
    }

    public Cursor getCursor(double x, double y, double r) {
        double distanceFromCenter = Circles.distanceFromCenter(this, x, y);
        if (distanceFromCenter < r) {
            return new CenterCursor(r);
        }
        if (!this.isCircle()) {
            double oy;
            double ox = x - this.getX();
            if (Circles.distance(this.leftX, this.leftY, ox, oy = y - this.getY()) < r) {
                return new LeftCursor(r);
            }
            if (Circles.distance(this.rightX, this.rightY, ox, oy) < r) {
                return new RightCursor(r);
            }
            if (this.rawIsInSector(x, y)) {
                if (distanceFromCenter - this.getRadius() < r) {
                    return new RadiusCursor();
                }
            } else if (distanceFromCenter - this.innerRadius < r) {
                return new InnerRadiusCursor(r);
            }
        } else if (distanceFromCenter - this.getRadius() < r) {
            return new RadiusOrAngleCursor(x, y, r);
        }
        return null;
    }

    public class InnerRadiusCursor
    implements Cursor {
        private double r;

        public InnerRadiusCursor(double r) {
            this.r = r;
        }

        @Override
        public Cursor update(double x, double y) {
            double ir = Circles.distanceFromCenter(SafeSector.this.point, x, y);
            if (ir < SafeSector.this.getRadius() && ir > this.r) {
                SafeSector.this.innerRadius = ir;
            }
            return this;
        }

        @Override
        public void ready(double x, double y) {
            this.update(x, y);
            if (SafeSector.this.getRadius() - SafeSector.this.innerRadius < this.r) {
                SafeSector.this.leftX = (SafeSector.this.leftY = (SafeSector.this.rightX = (SafeSector.this.rightY = 0.0)));
                SafeSector.this.innerRadius = SafeSector.this.getRadius() / 2.0;
            }
        }
    }

    public class InnerCircle
    implements Circle,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public double getRadius() {
            return SafeSector.this.innerRadius;
        }

        @Override
        public double getX() {
            return SafeSector.this.point.getX();
        }

        @Override
        public double getY() {
            return SafeSector.this.point.getY();
        }
    }

    public class RightCursor
    extends AngleCursor {
        public RightCursor(double r) {
            super(r);
        }

        @Override
        public Cursor update(double x, double y) {
            SafeSector.this.rightX = x - SafeSector.this.getX();
            SafeSector.this.rightY = y - SafeSector.this.getY();
            return this;
        }

        @Override
        public void ready(double x, double y) {
            this.update(x, y);
            super.ready(x, y);
        }
    }

    public class LeftCursor
    extends AngleCursor {
        public LeftCursor(double r) {
            super(r);
        }

        @Override
        public Cursor update(double x, double y) {
            SafeSector.this.leftX = x - SafeSector.this.getX();
            SafeSector.this.leftY = y - SafeSector.this.getY();
            return this;
        }

        @Override
        public void ready(double x, double y) {
            this.update(x, y);
            super.ready(x, y);
        }
    }

    public abstract class AngleCursor
    implements Cursor {
        private final double r;

        public AngleCursor(double r) {
            this.r = r;
        }

        @Override
        public void ready(double x, double y) {
            SafeSector.this.updateSector();
            if (Circles.distance(SafeSector.this.leftX, SafeSector.this.leftY, SafeSector.this.rightX, SafeSector.this.rightY) < this.r) {
                SafeSector.this.leftX = (SafeSector.this.leftY = (SafeSector.this.rightX = (SafeSector.this.rightY = 0.0)));
            }
        }
    }

    public class RadiusCursor
    implements Cursor {
        @Override
        public Cursor update(double x, double y) {
            SafeSector.this.setRadius(Circles.distanceFromCenter(SafeSector.this.point, x, y));
            return this;
        }

        @Override
        public void ready(double x, double y) {
            this.update(x, y);
            SafeSector.this.innerRadius = Math.min(SafeSector.this.innerRadius, SafeSector.this.getRadius());
        }
    }

    public class RadiusOrAngleCursor
    implements Cursor {
        private final double x;
        private final double y;
        private final double r;

        public RadiusOrAngleCursor(double x, double y, double r) {
            this.x = x - SafeSector.this.getX();
            this.y = y - SafeSector.this.getY();
            this.r = r;
        }

        @Override
        public Cursor update(double x, double y) {
            double oy;
            double ox = x - SafeSector.this.getX();
            double distance = Circles.distance(this.x, this.y, ox, oy = y - SafeSector.this.getY());
            if (distance > this.r) {
                Cursor cursor;
                if (Math.abs(Circles.distanceFromCenter(SafeSector.this.point, x, y) - SafeSector.this.getRadius()) > this.r / 2.0) {
                    cursor = new RadiusCursor();
                } else if (Vectors.isClockwise(this.x, this.y, ox, oy)) {
                    cursor = new LeftCursor(this.r);
                    SafeSector.this.rightX = this.x;
                    SafeSector.this.rightY = this.y;
                } else {
                    cursor = new RightCursor(this.r);
                    SafeSector.this.leftX = this.x;
                    SafeSector.this.leftY = this.y;
                }
                cursor.update(x, y);
                return cursor;
            }
            return this;
        }

        @Override
        public void ready(double x, double y) {
        }
    }

    public class CenterCursor
    implements Cursor {
        private final double r;

        private CenterCursor(double r) {
            this.r = r;
        }

        @Override
        public Cursor update(double x, double y) {
            SafeSector.this.set(x, y);
            return this;
        }

        @Override
        public void ready(double x, double y) {
            this.update(x, y);
            if (Circles.distance(SafeSector.this.attachCircle, SafeSector.this.detachPoint) < this.r / 3.0) {
                SafeSector.this.point = SafeSector.this.attachCircle;
                SafeSector.this.detachPoint = null;
            }
        }
    }

    public static interface Cursor {
        public Cursor update(double var1, double var3);

        public void ready(double var1, double var3);
    }
}

