/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.navi;

public class TrueWind {
    private double boatSpeed;
    private double relativeAngle;
    private double relativeSpeed;
    private double trueAngle;
    private double trueSpeed;

    public void calc() {
        double x = Math.cos(this.relativeAngle) * this.relativeSpeed - this.boatSpeed;
        double y = Math.sin(this.relativeAngle) * this.relativeSpeed;
        this.trueSpeed = Math.hypot(x, y);
        this.trueAngle = Math.toDegrees(Math.atan2(y, x));
        if (this.trueAngle < 0.0) {
            this.trueAngle += 360.0;
        }
    }

    public double getTrueAngle() {
        return this.trueAngle;
    }

    public double getTrueSpeed() {
        return this.trueSpeed;
    }

    public void setBoatSpeed(double boatSpeed) {
        this.boatSpeed = boatSpeed;
    }

    public void setRelativeAngle(double degrees) {
        this.relativeAngle = Math.toRadians(degrees);
    }

    public void setRelativeSpeed(double relativeSpeed) {
        this.relativeSpeed = relativeSpeed;
    }

    public String toString() {
        return "TrueWind{boatSpeed=" + this.boatSpeed + ", relativeAngle=" + this.relativeAngle + ", relativeSpeed=" + this.relativeSpeed + ", trueAngle=" + this.trueAngle + ", trueSpeed=" + this.trueSpeed + '}';
    }
}

