/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.navi.cpa;

import org.vesalainen.navi.Navis;

public class Vessel {
    private static final double Pi2 = Math.PI * 2;
    protected long time;
    protected double latitude;
    protected double longitude;
    protected double speed;
    protected double bearing = Double.NaN;
    protected double rateOfTurn;
    protected long prevTime;
    protected double prevLatitude;
    protected double prevLongitude;
    protected double centerLatitude = Double.NaN;
    protected double centerLongitude = Double.NaN;
    protected double radius = Double.NaN;

    public void update(long time, double latitude, double longitude, double rateOfTurn) {
        if (this.prevTime > 0L) {
            this.time = time;
            this.latitude = latitude;
            this.longitude = longitude;
            this.speed = Navis.speed(this.prevTime, this.prevLatitude, this.prevLongitude, time, latitude, longitude);
            this.bearing = Navis.bearing(this.prevLatitude, this.prevLongitude, latitude, longitude);
            this.rateOfTurn = rateOfTurn;
            this.calc();
        }
        this.prevTime = time;
        this.prevLatitude = latitude;
        this.prevLongitude = longitude;
    }

    public void update(long time, double latitude, double longitude, double speed, double bearing, double rateOfTurn) {
        this.time = time;
        this.latitude = latitude;
        this.longitude = longitude;
        this.speed = speed;
        this.bearing = bearing;
        this.rateOfTurn = rateOfTurn;
        this.calc();
    }

    private void calc() {
        double arot = Math.abs(this.rateOfTurn);
        if (arot > 0.0) {
            double hoursForFullCircle = 360.0 / arot / 60.0;
            this.radius = this.speed * hoursForFullCircle / (Math.PI * 2);
            double b = Navis.normalizeAngle(this.bearing + 90.0 * Math.signum(this.rateOfTurn));
            this.centerLatitude = this.latitude + Navis.deltaLatitude(this.radius, b);
            this.centerLongitude = Navis.addLongitude(this.longitude, Navis.deltaLongitude(this.latitude, this.radius, b));
        } else {
            this.radius = Double.NaN;
            this.centerLatitude = Double.NaN;
            this.centerLongitude = Double.NaN;
        }
    }

    public static final double estimatedDistance(Vessel v1, Vessel v2, long et) {
        return Navis.distance(v1.estimatedLatitude(et), v1.estimatedLongitude(et), v2.estimatedLatitude(et), v2.estimatedLongitude(et));
    }

    public final double estimatedLatitude(long et) {
        this.checkState();
        if (this.rateOfTurn == 0.0) {
            double dist = this.calcDist(et);
            return this.latitude + Navis.deltaLatitude(dist, this.bearing);
        }
        double deg = this.calcDeg(et);
        return this.centerLatitude + Navis.deltaLatitude(this.radius, deg);
    }

    public final double estimatedLongitude(long et) {
        this.checkState();
        if (this.rateOfTurn == 0.0) {
            double dist = this.calcDist(et);
            return Navis.addLongitude(this.longitude, Navis.deltaLongitude(this.latitude, dist, this.bearing));
        }
        double deg = this.calcDeg(et);
        return Navis.addLongitude(this.centerLongitude, Navis.deltaLongitude(this.latitude, this.radius, deg));
    }

    private double calcDist(long et) {
        if (et < this.time) {
            throw new IllegalArgumentException("cannot estimate past");
        }
        double dh = (double)(et - this.time) / 3600000.0;
        return this.speed * dh;
    }

    private double calcDeg(long et) {
        if (et < this.time) {
            throw new IllegalArgumentException("cannot estimate past");
        }
        double dm = (double)(et - this.time) / 60000.0;
        return Navis.normalizeAngle(this.bearing - 90.0 * Math.signum(this.rateOfTurn) + this.rateOfTurn * dm);
    }

    private void checkState() {
        if (Double.isNaN(this.bearing)) {
            throw new IllegalStateException("not updated");
        }
    }

    public double getRadius() {
        return this.radius;
    }

    public double getCenterLatitude() {
        return this.centerLatitude;
    }

    public double getCenterLongitude() {
        return this.centerLongitude;
    }
}

