/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.vesalainen.util.MimeTypes;

public class FormPoster {
    private static final String CRLF = "\r\n";
    private final Map<String, String> formData = new HashMap<String, String>();
    private final List<File> fileList = new ArrayList<File>();
    private final URL action;

    public FormPoster(URL action) {
        this.action = action;
    }

    public void post() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.action.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        String uid = UUID.randomUUID().toString();
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + uid);
        try (PrintStream ps = new PrintStream(connection.getOutputStream(), false, "utf-8");){
            for (String name : this.formData.keySet()) {
                String value = this.formData.get(name);
                ps.append("--" + uid);
                ps.append(CRLF);
                ps.append("Content-Disposition: form-data; name=\"" + name + "\"");
                ps.append(CRLF);
                ps.append("Content-Type: text/plain; charset=utf-8");
                ps.append(CRLF);
                ps.append(CRLF);
                ps.append(value);
                ps.append(CRLF);
            }
            byte[] buffer = new byte[8192];
            for (File file : this.fileList) {
                String name = file.getName();
                ps.append("--" + uid);
                ps.append(CRLF);
                ps.append("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + name + "\"");
                ps.append(CRLF);
                ps.append("Content-Type: " + MimeTypes.getMimeType(file));
                ps.append(CRLF);
                ps.append("Content-Transfer-Encoding: binary");
                ps.append(CRLF);
                ps.append(CRLF);
                FileInputStream fis = new FileInputStream(file);
                int rc = fis.read(buffer);
                while (rc != -1) {
                    ps.write(buffer, 0, rc);
                    rc = fis.read(buffer);
                }
                fis.close();
                ps.append(CRLF);
            }
            ps.append("--" + uid + "--");
            ps.append(CRLF);
        }
        if (connection.getResponseCode() != 200) {
            throw new IOException(connection.getResponseCode() + " " + connection.getResponseMessage());
        }
    }

    public void setFormData(String name, String value) {
        this.formData.put(name, value);
    }

    public void addFiles(File ... files) {
        for (File file : files) {
            this.fileList.add(file);
        }
    }
}

