/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.vesalainen.util.logging.JavaLogging;

public class AutoCloseableList<T extends AutoCloseable>
extends JavaLogging
implements AutoCloseable {
    private final List<WeakReference<T>> list = new ArrayList<WeakReference<T>>();

    public AutoCloseableList() {
        this.setLogger(this.getClass());
    }

    public AutoCloseableList(Collection<T> collection) {
        this.setLogger(this.getClass());
        for (AutoCloseable t : collection) {
            this.add(t);
        }
    }

    public final void add(T item) {
        Iterator<WeakReference<T>> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            WeakReference<T> next = iterator.next();
            if (next.get() != null) continue;
            this.fine("removed autocloseable", new Object[0]);
            iterator.remove();
        }
        this.fine("add autocloseable %s", item);
        this.list.add(new WeakReference<T>(item));
    }

    @Override
    public void close() throws IOException {
        for (WeakReference<T> r : this.list) {
            try {
                AutoCloseable t = (AutoCloseable)r.get();
                if (t == null) continue;
                this.fine("closing %s", t);
                t.close();
                this.fine("closed %s", t);
            }
            catch (Exception exception) {}
        }
    }
}

