/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.vesalainen.util.AbstractProvisioner;
import org.vesalainen.util.CmdArgsException;
import org.vesalainen.util.ConvertUtility;
import org.vesalainen.util.HashMapList;
import org.vesalainen.util.MapList;

public class CmdArgs<T>
extends AbstractProvisioner<T> {
    private final Map<String, Option> map = new HashMap<String, Option>();
    private final MapList<String, Option> groups = new HashMapList<String, Option>();
    private final List<Class<?>> types = new ArrayList();
    private final List<String> names = new ArrayList<String>();
    private Map<String, Object> options;
    private Map<String, Object> arguments;
    private String effectiveGroup;

    @Override
    public Object getValue(String name) {
        Object ob = this.options.get(name);
        if (ob != null) {
            return ob;
        }
        return this.arguments.get(name);
    }

    public void setArgs(String ... args) throws CmdArgsException {
        try {
            int len;
            this.options = new HashMap<String, Object>();
            Option opt = null;
            int index = 0;
            for (String arg : args) {
                if (opt != null) {
                    this.options.put(opt.name, ConvertUtility.convert(opt.cls, arg));
                    opt = null;
                } else {
                    if (!this.map.containsKey(arg)) break;
                    opt = this.map.get(arg);
                    if (opt.exclusiveGroup != null) {
                        if (this.effectiveGroup != null && !this.effectiveGroup.equals(opt.exclusiveGroup)) {
                            throw new CmdArgsException(opt.exclusiveGroup + " mix with " + this.effectiveGroup, this);
                        }
                        this.effectiveGroup = opt.exclusiveGroup;
                    }
                }
                ++index;
            }
            if ((len = args.length - index) != this.types.size()) {
                throw new CmdArgsException("wrong number of arguments", this);
            }
            this.arguments = new HashMap<String, Object>();
            for (int ii = 0; ii < len; ++ii) {
                Object value = ConvertUtility.convert(this.types.get(ii), args[ii + index]);
                this.arguments.put(this.names.get(ii), value);
            }
            for (Option o : this.map.values()) {
                if (!o.mandatory || this.options.containsKey(o.name)) continue;
                throw new CmdArgsException("mandatory option " + o.name + ": " + o.description + " missing", this);
            }
            if (this.effectiveGroup != null) {
                for (Option o : this.groups.get(this.effectiveGroup)) {
                    if (!o.mandatory || this.options.containsKey(o.name)) continue;
                    throw new CmdArgsException(this.effectiveGroup + " option " + o.name + ": " + o.description + " missing", this);
                }
            }
        }
        catch (Exception ex) {
            throw new CmdArgsException(ex, this);
        }
    }

    public String getEffectiveGroup() {
        if (this.arguments == null) {
            throw new IllegalStateException("setArgs not called");
        }
        return this.effectiveGroup;
    }

    public Object getArgument(String name) {
        if (this.arguments == null) {
            throw new IllegalStateException("setArgs not called");
        }
        return this.arguments.get(name);
    }

    public <T> T getOption(String name) {
        if (this.arguments == null) {
            throw new IllegalStateException("setArgs not called");
        }
        Object value = this.options.get(name);
        if (value == null) {
            Option opt = this.map.get(name);
            if (opt == null) {
                throw new IllegalArgumentException("option " + name + " not found");
            }
            if (opt.defValue != null) {
                return (T)opt.defValue;
            }
            throw new IllegalArgumentException(name + " not found");
        }
        return (T)value;
    }

    public void addArgument(String name) {
        this.addArgument(String.class, name);
    }

    public <T> void addArgument(Class<T> cls, String name) {
        if (this.map.containsKey(name)) {
            throw new IllegalArgumentException(name + " is already added as option");
        }
        this.types.add(cls);
        this.names.add(name);
    }

    public <T> void addOption(String name, String description) {
        this.addOption(String.class, name, description, null);
    }

    public <T> void addOption(Class<T> cls, String name, String description) {
        this.addOption(cls, name, description, null);
    }

    public <T> void addOption(Class<T> cls, String name, String description, String exclusiveGroup) {
        if (this.names.contains(name)) {
            throw new IllegalArgumentException(name + " is already added as argument");
        }
        Option<T> opt = new Option<T>(cls, name, description, exclusiveGroup);
        Option<T> old = this.map.put(name, opt);
        if (old != null) {
            throw new IllegalArgumentException(name + " was already added");
        }
        if (exclusiveGroup != null) {
            this.groups.add(exclusiveGroup, opt);
        }
    }

    public <T> void addOption(String name, String description, String exclusiveGroup, T defValue) {
        Option<T> opt = new Option<T>(name, description, exclusiveGroup, defValue);
        Option<T> old = this.map.put(name, opt);
        if (old != null) {
            throw new IllegalArgumentException(name + " was already added");
        }
        if (exclusiveGroup != null) {
            this.groups.add(exclusiveGroup, opt);
        }
    }

    public String getUsage() {
        HashSet<Option> set = new HashSet<Option>();
        StringBuilder sb = new StringBuilder();
        sb.append("usage: ");
        boolean n1 = false;
        for (Map.Entry e : this.groups.entrySet()) {
            if (n1) {
                sb.append("|");
            }
            n1 = true;
            sb.append("[");
            boolean n2 = false;
            for (Option opt : (List)e.getValue()) {
                if (n2) {
                    sb.append(" ");
                }
                n2 = true;
                this.append(sb, opt);
                set.add(opt);
            }
            sb.append("]");
        }
        for (Option opt : this.map.values()) {
            if (set.contains(opt)) continue;
            sb.append(" ");
            this.append(sb, opt);
        }
        for (String n : this.names) {
            sb.append(" <").append(n).append(">");
        }
        return sb.toString();
    }

    private void append(StringBuilder sb, Option opt) {
        sb.append(opt.name).append(" ");
        sb.append("<").append(opt.description).append(">");
    }

    public class Option<T> {
        private final Class<T> cls;
        private final String name;
        private final String description;
        private final String exclusiveGroup;
        private boolean mandatory;
        private T defValue;

        public Option(Class<T> cls, String name, String description, String exclusiveGroup) {
            this.cls = cls;
            this.name = name;
            this.description = description;
            this.exclusiveGroup = exclusiveGroup;
            this.mandatory = true;
        }

        public Option(String name, String description, String exclusiveGroup, T defValue) {
            this.name = name;
            this.description = description;
            this.defValue = defValue;
            this.exclusiveGroup = exclusiveGroup;
            this.cls = defValue.getClass();
        }

        public T getValue(String str) {
            return ConvertUtility.convert(this.cls, str);
        }
    }
}

