/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.Calendar;
import java.util.Date;
import org.vesalainen.util.ConvertUtilityException;
import org.vesalainen.util.Convertable;

public class ConvertUtility {
    public static Object convertPrimitive(Object object) {
        if (object == null) {
            return object;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isPrimitive()) {
            if (Boolean.TYPE.equals(clazz)) {
                Boolean b = (Boolean)object;
                return b;
            }
            if (Byte.TYPE.equals(clazz)) {
                Byte b = (Byte)object;
                return b;
            }
            if (Character.TYPE.equals(clazz)) {
                Character c = (Character)object;
                return c;
            }
            if (Short.TYPE.equals(clazz)) {
                Short s = (Short)object;
                return s;
            }
            if (Integer.TYPE.equals(clazz)) {
                Integer i = (Integer)object;
                return i;
            }
            if (Long.TYPE.equals(clazz)) {
                Long l = (Long)object;
                return l;
            }
            if (Float.TYPE.equals(clazz)) {
                Float f = (Float)object;
                return f;
            }
            if (Double.TYPE.equals(clazz)) {
                Double d = (Double)object;
                return d;
            }
            throw new IllegalArgumentException("Unknown primitive type'" + clazz);
        }
        return object;
    }

    public static <T> void convert(T[] target, Object[] object) throws ConvertUtilityException {
        Object[] result = (Object[])ConvertUtility.convert(target.getClass(), (Object)object);
        for (int ii = 0; ii < result.length; ++ii) {
            target[ii] = result[ii];
        }
    }

    public static <T> T convert(Class<T> expectedReturnType, Object object) throws ConvertUtilityException {
        try {
            Convertable cc;
            TypeVariable<Class<?>>[] tvl;
            if (object == null) {
                return null;
            }
            Class<?> clazz = ConvertUtility.openBox(object.getClass());
            if (clazz.isArray()) {
                if (int[].class.equals(clazz)) {
                    int[] arr = (int[])object;
                    Object[] oa = new Object[arr.length];
                    for (int ii = 0; ii < arr.length; ++ii) {
                        oa[ii] = ConvertUtility.convert(expectedReturnType, arr[ii]);
                    }
                    return (T)oa;
                }
                if (long[].class.equals(clazz)) {
                    long[] arr = (long[])object;
                    Object[] oa = new Object[arr.length];
                    for (int ii = 0; ii < arr.length; ++ii) {
                        oa[ii] = ConvertUtility.convert(expectedReturnType, arr[ii]);
                    }
                    return (T)oa;
                }
                if (short[].class.equals(clazz)) {
                    short[] arr = (short[])object;
                    Object[] oa = new Object[arr.length];
                    for (int ii = 0; ii < arr.length; ++ii) {
                        oa[ii] = ConvertUtility.convert(expectedReturnType, arr[ii]);
                    }
                    return (T)oa;
                }
                if (float[].class.equals(clazz)) {
                    float[] arr = (float[])object;
                    Object[] oa = new Object[arr.length];
                    for (int ii = 0; ii < arr.length; ++ii) {
                        oa[ii] = ConvertUtility.convert(expectedReturnType, Float.valueOf(arr[ii]));
                    }
                    return (T)oa;
                }
                if (double[].class.equals(clazz)) {
                    double[] arr = (double[])object;
                    Object[] oa = new Object[arr.length];
                    for (int ii = 0; ii < arr.length; ++ii) {
                        oa[ii] = ConvertUtility.convert(expectedReturnType, arr[ii]);
                    }
                    return (T)oa;
                }
                if (char[].class.equals(clazz)) {
                    char[] arr = (char[])object;
                    Object[] oa = new Object[arr.length];
                    for (int ii = 0; ii < arr.length; ++ii) {
                        oa[ii] = ConvertUtility.convert(expectedReturnType, Character.valueOf(arr[ii]));
                    }
                    return (T)oa;
                }
                if (byte[].class.equals(clazz)) {
                    byte[] arr = (byte[])object;
                    Object[] oa = new Object[arr.length];
                    for (int ii = 0; ii < arr.length; ++ii) {
                        oa[ii] = ConvertUtility.convert(expectedReturnType, arr[ii]);
                    }
                    return (T)oa;
                }
                if (boolean[].class.equals(clazz)) {
                    boolean[] arr = (boolean[])object;
                    Object[] oa = new Object[arr.length];
                    for (int ii = 0; ii < arr.length; ++ii) {
                        oa[ii] = ConvertUtility.convert(expectedReturnType, arr[ii]);
                    }
                    return (T)oa;
                }
            }
            if (expectedReturnType.isAssignableFrom(clazz)) {
                return (T)object;
            }
            if (object instanceof Convertable && expectedReturnType.isAssignableFrom((tvl = (cc = (Convertable)object).getClass().getTypeParameters())[1].getGenericDeclaration())) {
                return (T)cc.convertTo();
            }
            if (expectedReturnType.equals(String.class)) {
                return (T)object.toString();
            }
            if (expectedReturnType.isPrimitive()) {
                Serializable b;
                if (Boolean.TYPE.equals(expectedReturnType) && object instanceof Boolean) {
                    b = (Boolean)object;
                    return (T)b;
                }
                if (Byte.TYPE.equals(expectedReturnType) && object instanceof Number) {
                    b = (Number)object;
                    return (T)b;
                }
                if (Character.TYPE.equals(expectedReturnType) && object instanceof Number) {
                    b = (Number)object;
                    return (T)b;
                }
                if (Short.TYPE.equals(expectedReturnType) && object instanceof Number) {
                    b = (Number)object;
                    return (T)b;
                }
                if (Integer.TYPE.equals(expectedReturnType) && object instanceof Number) {
                    b = (Number)object;
                    return (T)b;
                }
                if (Long.TYPE.equals(expectedReturnType) && object instanceof Number) {
                    b = (Number)object;
                    return (T)b;
                }
                if (Float.TYPE.equals(expectedReturnType) && object instanceof Number) {
                    b = (Number)object;
                    return (T)b;
                }
                if (Double.TYPE.equals(expectedReturnType) && object instanceof Number) {
                    b = (Number)object;
                    return (T)b;
                }
            }
            if (object instanceof String) {
                String string = (String)object;
                if (expectedReturnType.isPrimitive()) {
                    if (Boolean.TYPE.equals(expectedReturnType)) {
                        return (T)Boolean.valueOf(string);
                    }
                    if (Byte.TYPE.equals(expectedReturnType)) {
                        return (T)Byte.valueOf(string);
                    }
                    if (Character.TYPE.equals(expectedReturnType)) {
                        if (string.length() != 1) {
                            throw new IllegalArgumentException("Cannot convert '" + string + "' to char");
                        }
                        Character cc2 = Character.valueOf(string.charAt(0));
                        return (T)cc2;
                    }
                    if (Short.TYPE.equals(expectedReturnType)) {
                        return (T)Short.valueOf(string);
                    }
                    if (Integer.TYPE.equals(expectedReturnType)) {
                        return (T)Integer.valueOf(string);
                    }
                    if (Long.TYPE.equals(expectedReturnType)) {
                        return (T)Long.valueOf(string);
                    }
                    if (Float.TYPE.equals(expectedReturnType)) {
                        return (T)Float.valueOf(string);
                    }
                    if (Double.TYPE.equals(expectedReturnType)) {
                        return (T)Double.valueOf(string);
                    }
                    throw new IllegalArgumentException("Unknown primitive type '" + expectedReturnType + "'");
                }
                if (expectedReturnType.isEnum()) {
                    return Enum.valueOf(expectedReturnType, string);
                }
                try {
                    Method method = expectedReturnType.getDeclaredMethod("parse", clazz);
                    return (T)method.invoke(null, object);
                }
                catch (NoSuchMethodException method) {
                    // empty catch block
                }
            }
            if (object instanceof Number) {
                Number number = (Number)object;
                if (expectedReturnType.isPrimitive()) {
                    if (Byte.class.equals(expectedReturnType)) {
                        return (T)Byte.valueOf(number.byteValue());
                    }
                    if (Short.class.equals(expectedReturnType)) {
                        return (T)Short.valueOf(number.shortValue());
                    }
                    if (Integer.class.equals(expectedReturnType)) {
                        return (T)Integer.valueOf(number.intValue());
                    }
                    if (Long.class.equals(expectedReturnType)) {
                        return (T)Long.valueOf(number.longValue());
                    }
                    if (Float.class.equals(expectedReturnType)) {
                        return (T)Float.valueOf(number.floatValue());
                    }
                    if (Double.class.equals(expectedReturnType)) {
                        return (T)Double.valueOf(number.doubleValue());
                    }
                    throw new IllegalArgumentException("Unknown primitive type '" + expectedReturnType + "'");
                }
            }
            if (object instanceof Calendar) {
                Calendar calendar = (Calendar)object;
                if (expectedReturnType.isPrimitive()) {
                    if (Long.TYPE.equals(expectedReturnType)) {
                        return (T)Long.valueOf(calendar.getTimeInMillis());
                    }
                    throw new IllegalArgumentException("Unknown primitive type '" + expectedReturnType + "'");
                }
                if (expectedReturnType.equals(Date.class)) {
                    return (T)calendar.getTime();
                }
            }
            if (object instanceof Date) {
                Date date = (Date)object;
                if (expectedReturnType.isPrimitive()) {
                    if (Long.TYPE.equals(expectedReturnType)) {
                        return (T)Long.valueOf(date.getTime());
                    }
                    throw new IllegalArgumentException("Unknown primitive type '" + expectedReturnType + "'");
                }
                if (expectedReturnType.equals(Calendar.class)) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    return (T)calendar;
                }
            }
            try {
                Method method = expectedReturnType.getDeclaredMethod("valueOf", clazz);
                return (T)method.invoke(null, object);
            }
            catch (NoSuchMethodException method) {
                try {
                    Constructor<T> cons = expectedReturnType.getConstructor(clazz);
                    return cons.newInstance(object);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new IllegalArgumentException("Cannot convert " + clazz + " to " + expectedReturnType);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex1) {
            throw new ConvertUtilityException(expectedReturnType, object, ex1);
        }
    }

    private static Class<?> openBox(Class<?> cls) {
        switch (cls.getName()) {
            case "java.lang.Boolean": {
                return Boolean.TYPE;
            }
            case "java.lang.Byte": {
                return Byte.TYPE;
            }
            case "java.lang.Character": {
                return Character.TYPE;
            }
            case "java.lang.Short": {
                return Short.TYPE;
            }
            case "java.lang.Integer": {
                return Integer.TYPE;
            }
            case "java.lang.Long": {
                return Long.TYPE;
            }
            case "java.lang.Float": {
                return Float.TYPE;
            }
            case "java.lang.Double": {
                return Double.TYPE;
            }
        }
        return cls;
    }
}

