/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util;

import java.util.Arrays;
import org.vesalainen.util.BankingCode;

public class CreditorReference {
    private static final char[] mask = new char[]{'7', '1', '3', '7', '1', '3', '7', '1', '3', '7', '1', '3', '7', '1', '3', '7', '1', '3', '7'};
    private char[] buffer = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};

    public CreditorReference(String str, boolean check) {
        str = str.replace(" ", "");
        if (str.startsWith("RF")) {
            str = str.substring(4);
            str.getChars(0, str.length(), this.buffer, this.buffer.length - str.length());
        } else {
            if (check ? str.length() > this.buffer.length : str.length() > this.buffer.length - 1) {
                throw new IllegalArgumentException(str + " is too long");
            }
            for (int ii = 0; ii < str.length(); ++ii) {
                if (str.charAt(ii) >= '0' && str.charAt(ii) <= '9') continue;
                throw new IllegalArgumentException(str + " contains non numeric characters");
            }
            if (check) {
                str.getChars(0, str.length(), this.buffer, this.buffer.length - str.length());
            } else {
                str.getChars(0, str.length(), this.buffer, this.buffer.length - 1 - str.length());
            }
            this.calcCheckDigit(check);
        }
    }

    public CreditorReference(long n, boolean check) {
        String str = String.valueOf(n);
        if (check) {
            str.getChars(0, str.length(), this.buffer, this.buffer.length - str.length());
        } else {
            str.getChars(0, str.length(), this.buffer, this.buffer.length - 1 - str.length());
        }
        this.calcCheckDigit(check);
    }

    private void calcCheckDigit(boolean check) {
        int chk = 0;
        for (int ii = 0; ii < this.buffer.length - 1; ++ii) {
            chk += (mask[ii] - 48) * (this.buffer[ii] - 48);
        }
        if (check) {
            if (this.buffer[this.buffer.length - 1] != (char)(48 + (char)((10 - chk % 10) % 10))) {
                throw new IllegalArgumentException(this + " has wrong check digit");
            }
        } else {
            this.buffer[this.buffer.length - 1] = (char)(48 + (char)((10 - chk % 10) % 10));
        }
    }

    public String toBankingBarcodeString() {
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < this.buffer.length; ++ii) {
            sb.append(this.buffer[ii]);
        }
        return sb.toString();
    }

    public String toRFString() {
        return BankingCode.create("RF", new String(this.buffer));
    }

    public String toFormattedRFString() {
        return BankingCode.format(BankingCode.create("RF", new String(this.buffer)));
    }

    public String toString() {
        boolean startzero = true;
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < this.buffer.length; ++ii) {
            if (startzero) {
                if (this.buffer[ii] == '0') continue;
                sb.append(this.buffer[ii]);
                startzero = false;
                continue;
            }
            if (ii % 5 == 0) {
                sb.append(' ');
            }
            sb.append(this.buffer[ii]);
        }
        return sb.toString();
    }

    public int fill(char version, int start, char[] buf) {
        switch (version) {
            case '2': 
            case '4': {
                for (int ii = 0; ii < this.buffer.length; ++ii) {
                    buf[start + ii] = this.buffer[ii];
                }
                return start + this.buffer.length;
            }
            case '5': {
                Arrays.fill(buf, start, start + 23, '0');
                String rfRef = this.toRFString();
                char[] cb = rfRef.substring(2, 4).toCharArray();
                for (int ii = 0; ii < 2; ++ii) {
                    buf[start + ii] = cb[ii];
                }
                cb = rfRef.substring(4).toCharArray();
                int fillen = 23 - cb.length;
                for (int ii = 0; ii < cb.length; ++ii) {
                    buf[start + fillen + ii] = cb[ii];
                }
                return start + 23;
            }
        }
        throw new IllegalArgumentException("wrong version " + version);
    }

    public static void main(String[] args) {
        try {
            CreditorReference vn = new CreditorReference("40871", false);
            if (!"RF82 4087 12".equals(vn.toRFString())) {
                System.err.println(vn.toRFString());
            }
            if (!"RF68 4095 46".equals((vn = new CreditorReference("40954", false)).toRFString())) {
                System.err.println("error");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

