/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util;

import java.util.EnumSet;

public class EnumSetFlagger {
    public static <E extends Enum<E>> int getFlag(EnumSet<E> eSet) {
        int flag = 0;
        for (Enum en : eSet) {
            int ordinal = en.ordinal();
            if (ordinal >= 32) {
                throw new IllegalArgumentException(eSet + " contains too many enums for int");
            }
            flag |= 1 << ordinal;
        }
        return flag;
    }

    public static <E extends Enum<E>> long getLongFlag(EnumSet<E> eSet) {
        long flag = 0L;
        for (Enum en : eSet) {
            long ordinal = en.ordinal();
            if (ordinal >= 64L) {
                throw new IllegalArgumentException(eSet + " contains too many enums for long");
            }
            flag |= (long)(1 << (int)ordinal);
        }
        return flag;
    }

    public static <E extends Enum<E>> EnumSet<E> getSet(Class<E> elementType, int flag) {
        EnumSet<Enum> set = EnumSet.noneOf(elementType);
        Enum[] enumConstants = (Enum[])elementType.getEnumConstants();
        if (enumConstants.length > 32) {
            throw new IllegalArgumentException(elementType + " contains too many enums for int");
        }
        for (int ii = 0; ii < enumConstants.length; ++ii) {
            if ((flag & 1 << ii) == 0) continue;
            set.add(enumConstants[ii]);
        }
        return set;
    }

    public static <E extends Enum<E>> EnumSet<E> getSet(Class<E> elementType, long flag) {
        EnumSet<Enum> set = EnumSet.noneOf(elementType);
        Enum[] enumConstants = (Enum[])elementType.getEnumConstants();
        if (enumConstants.length > 64) {
            throw new IllegalArgumentException(elementType + " contains too many enums for long");
        }
        for (int ii = 0; ii < enumConstants.length; ++ii) {
            if ((flag & (long)(1 << ii)) == 0L) continue;
            set.add(enumConstants[ii]);
        }
        return set;
    }
}

