/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentArraySet<T>
implements Set<T> {
    private final List<T> list = new ArrayList<T>();
    private Iter iterator;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.rwLock.writeLock();

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.readLock.lock();
        try {
            boolean bl = this.list.contains(o);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        this.writeLock.lock();
        if (this.iterator == null) {
            this.iterator = new Iter();
        } else {
            this.iterator.reset();
        }
        return this.iterator;
    }

    public void unlock() {
        if (this.writeLock.isHeldByCurrentThread()) {
            this.writeLock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        this.readLock.lock();
        try {
            Object[] objectArray = this.list.toArray();
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.readLock.lock();
        try {
            T[] TArray = this.list.toArray(a);
            return TArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean add(T e) {
        this.writeLock.lock();
        try {
            if (!this.list.contains(e)) {
                this.list.add(e);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        this.writeLock.lock();
        try {
            boolean bl = this.list.remove(o);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.readLock.lock();
        try {
            boolean bl = this.list.containsAll(c);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.writeLock.lock();
        try {
            boolean changed = false;
            for (T o : c) {
                if (!this.add(o)) continue;
                changed = true;
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.writeLock.lock();
        try {
            boolean bl = this.list.retainAll(c);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.writeLock.lock();
        try {
            boolean bl = this.list.removeAll(c);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.list.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private class Iter
    implements Iterator<T> {
        private int index;

        public Iter() {
            this.index = ConcurrentArraySet.this.size();
        }

        private void reset() {
            this.index = ConcurrentArraySet.this.size();
        }

        @Override
        public boolean hasNext() {
            boolean hasNext;
            boolean bl = hasNext = this.index > 0;
            if (!hasNext) {
                ConcurrentArraySet.this.writeLock.unlock();
            }
            return hasNext;
        }

        @Override
        public T next() {
            return ConcurrentArraySet.this.list.get(--this.index);
        }

        @Override
        public void remove() {
            ConcurrentArraySet.this.list.remove(this.index);
        }
    }
}

