/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.concurrent;

import java.nio.ByteBuffer;
import org.vesalainen.util.concurrent.RingSpan;

public class RingbufferSupport {
    private final ByteBuffer bb;
    private final ByteBuffer bb1;
    private final ByteBuffer bb2;
    private final ByteBuffer[] ar0;
    private final ByteBuffer[] ar1;
    private final ByteBuffer[] ar2;
    private final int capacity;

    public RingbufferSupport(ByteBuffer bb) {
        this.bb = bb;
        this.capacity = bb.capacity();
        this.bb1 = bb.duplicate();
        this.bb2 = bb.duplicate();
        this.ar0 = new ByteBuffer[0];
        this.ar1 = new ByteBuffer[]{this.bb1};
        this.ar2 = new ByteBuffer[]{this.bb1, this.bb2};
    }

    public byte get(int index) {
        return this.bb.get(index);
    }

    public ByteBuffer[] getBuffers(int start, int len) {
        if (len == 0) {
            return this.ar0;
        }
        if (len > this.capacity) {
            throw new IllegalArgumentException("len=" + len + " > capacity=" + this.capacity);
        }
        int s = start % this.capacity;
        int e = (start + len) % this.capacity;
        return this.getBuffersForSpan(s, e);
    }

    public ByteBuffer[] getBuffersForSpan(RingSpan s) {
        return this.getBuffersForSpan(s.start(), s.end());
    }

    public ByteBuffer[] getBuffersForSpan(int s, int e) {
        if (s < e) {
            this.bb1.limit(e);
            this.bb1.position(s);
            return this.ar1;
        }
        this.bb1.limit(this.capacity);
        this.bb1.position(s);
        if (e > 0) {
            this.bb2.limit(e);
            this.bb2.position(0);
            return this.ar2;
        }
        return this.ar1;
    }
}

