/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.concurrent;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ScatteringByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReentrantLock;
import org.vesalainen.util.concurrent.BufferConsumer;
import org.vesalainen.util.concurrent.RingSpan;
import org.vesalainen.util.concurrent.RingbufferSupport;

public class SynchronizedRingBuffer {
    private final ByteBuffer bb;
    private final RingbufferSupport bs;
    private RingSpan span;
    private final ReentrantLock lock = new ReentrantLock();
    private final Semaphore semaphore;
    private int minRead;
    private List<BufferConsumer> consumers = new ArrayList<BufferConsumer>();
    private List<Thread> threads = new ArrayList<Thread>();
    private int capacity;

    public SynchronizedRingBuffer(int capacity, boolean direct, int minRead) {
        if (minRead > capacity) {
            throw new IllegalArgumentException("minRead > capacity");
        }
        this.bb = direct ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
        this.capacity = capacity;
        this.minRead = minRead;
        this.bs = new RingbufferSupport(this.bb);
        this.span = new RingSpan(capacity);
        this.semaphore = new Semaphore(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumer(BufferConsumer consumer) {
        this.checkState();
        this.lock.lock();
        try {
            consumer.setRing(this);
            int count = this.consumers.size();
            Thread thread = new Thread((Runnable)consumer, "BufferConsumer-" + count);
            this.threads.add(thread);
            this.consumers.add(consumer);
            thread.start();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ScatteringByteChannel channel) throws IOException {
        try {
            int need = this.minRead;
            block5: while (true) {
                this.semaphore.acquire(need);
                int rc = (int)channel.read(this.bs.getBuffers(this.span.end(), this.minRead));
                if (rc == -1) {
                    this.semaphore.acquire(this.capacity - this.minRead);
                    break;
                }
                need = rc;
                this.lock.lock();
                try {
                    this.span.increment(rc);
                }
                finally {
                    this.lock.unlock();
                }
                Iterator<BufferConsumer> iterator = this.consumers.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block5;
                    BufferConsumer consumer = iterator.next();
                    consumer.input(rc);
                }
                break;
            }
            this.stopThreads();
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        this.lock.lock();
        try {
            int min = Integer.MAX_VALUE;
            for (BufferConsumer consumer : this.consumers) {
                min = Math.min(min, this.span.length(consumer.position()));
            }
            if (min < 0) {
                System.err.println();
            }
            this.semaphore.release(min);
            this.span.addStart(min);
        }
        finally {
            this.lock.unlock();
        }
    }

    ByteBuffer getBuffer() {
        return this.bb;
    }

    private void checkState() {
        if (this.consumers == null) {
            throw new IllegalStateException("stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThreads() {
        if (this.threads.isEmpty()) {
            throw new IllegalStateException("threads are already interrupted");
        }
        this.lock.lock();
        try {
            Thread currentThread = Thread.currentThread();
            for (Thread thread : this.threads) {
                if (currentThread.equals(thread)) continue;
                thread.interrupt();
            }
            this.threads = null;
            this.consumers = null;
        }
        finally {
            this.lock.unlock();
        }
    }
}

