/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.fi;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.vesalainen.util.CreditorReference;
import org.vesalainen.util.fi.BankAccountNumber;

public class BankingBarcode {
    private char version = (char)53;
    private BankAccountNumber account;
    private double total;
    private int cents;
    private CreditorReference reference;
    private Calendar dueDate;
    private String bic;

    public BankingBarcode(BankAccountNumber account, double total, CreditorReference reference, Date dueDate, String bic) {
        this.account = account;
        this.total = total;
        this.cents = (int)Math.round(total * 100.0);
        this.reference = reference;
        if (dueDate != null) {
            this.dueDate = Calendar.getInstance();
            this.dueDate.setTime(dueDate);
        }
        this.bic = bic;
    }

    public BankingBarcode(char version, String account, double total, String reference, Date dueDate, String bic) {
        if (version != '4' && version != '5') {
            throw new IllegalArgumentException("version " + version + " is illegal");
        }
        this.version = version;
        this.account = new BankAccountNumber(account);
        this.total = total;
        this.cents = (int)Math.round(total * 100.0);
        this.reference = new CreditorReference(reference, false);
        if (dueDate != null) {
            this.dueDate = Calendar.getInstance();
            this.dueDate.setTime(dueDate);
        }
        this.bic = bic;
    }

    public double getTotal() {
        return this.total;
    }

    public Date getDueDate() {
        return this.dueDate.getTime();
    }

    public BankAccountNumber getAccount() {
        return this.account;
    }

    public CreditorReference getReference() {
        return this.reference;
    }

    public String toString() {
        switch (this.version) {
            case '2': {
                return this.toString2();
            }
            case '4': {
                return this.toString4();
            }
            case '5': {
                return this.toString5();
            }
        }
        throw new IllegalArgumentException("wrong version " + this.version);
    }

    public String toString2() {
        char ver = '2';
        int[] chk = new int[]{3, 7, 1};
        int cd = 0;
        int ii = 0;
        int jj = 0;
        String sum = null;
        char[] buf = new char[54];
        Arrays.fill(buf, '0');
        ii = 0;
        buf[ii++] = ver;
        ii = this.account.fill(ver, ii, buf);
        sum = String.valueOf(this.cents);
        sum.getChars(0, sum.length(), buf, ii + 8 - sum.length());
        ii += 8;
        ii = this.reference.fill(ver, ii, buf);
        if (this.dueDate != null) {
            sum = String.valueOf(this.dueDate.get(1));
            sum.getChars(2, sum.length(), buf, ii);
            sum = String.valueOf(this.dueDate.get(2) + 1);
            sum.getChars(0, sum.length(), buf, (ii += 2) + 2 - sum.length());
            sum = String.valueOf(this.dueDate.get(5));
            sum.getChars(0, sum.length(), buf, (ii += 2) + 2 - sum.length());
            ii += 2;
        } else {
            ii += 6;
        }
        ii += 4;
        for (jj = 0; jj < 53; ++jj) {
            cd += (buf[jj] - 48) * chk[jj % 3];
        }
        buf[ii] = (char)(48 + (10 - cd % 10) % 10);
        return new String(buf);
    }

    public String toString4() {
        char ver = '4';
        int[] chk = new int[]{3, 7, 1};
        boolean cd = false;
        int ii = 0;
        boolean jj = false;
        String sum = null;
        char[] buf = new char[54];
        Arrays.fill(buf, '0');
        ii = 0;
        buf[ii++] = ver;
        ii = this.account.fill(ver, ii, buf);
        sum = String.valueOf(this.cents);
        sum.getChars(0, sum.length(), buf, ii + 8 - sum.length());
        ii += 8;
        ii += 3;
        ii = this.reference.fill(ver, ii, buf);
        if (this.dueDate != null) {
            sum = String.valueOf(this.dueDate.get(1));
            sum.getChars(2, sum.length(), buf, ii);
            sum = String.valueOf(this.dueDate.get(2) + 1);
            sum.getChars(0, sum.length(), buf, (ii += 2) + 2 - sum.length());
            sum = String.valueOf(this.dueDate.get(5));
            sum.getChars(0, sum.length(), buf, (ii += 2) + 2 - sum.length());
            ii += 2;
        } else {
            ii += 6;
        }
        return new String(buf);
    }

    public String toString5() {
        char ver = '5';
        int[] chk = new int[]{3, 7, 1};
        boolean cd = false;
        int ii = 0;
        boolean jj = false;
        String sum = null;
        char[] buf = new char[54];
        Arrays.fill(buf, '0');
        ii = 0;
        buf[ii++] = ver;
        ii = this.account.fill(ver, ii, buf);
        sum = String.valueOf(this.cents);
        sum.getChars(0, sum.length(), buf, ii + 8 - sum.length());
        ii += 8;
        ii = this.reference.fill(ver, ii, buf);
        if (this.dueDate != null) {
            sum = String.valueOf(this.dueDate.get(1));
            sum.getChars(2, sum.length(), buf, ii);
            sum = String.valueOf(this.dueDate.get(2) + 1);
            sum.getChars(0, sum.length(), buf, (ii += 2) + 2 - sum.length());
            sum = String.valueOf(this.dueDate.get(5));
            sum.getChars(0, sum.length(), buf, (ii += 2) + 2 - sum.length());
            ii += 2;
        } else {
            ii += 6;
        }
        return new String(buf);
    }
}

