/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.fi;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.vesalainen.util.fi.StringParser;

public class Hyphenator {
    public static final char HYPHEN = '\u00ad';
    public static final String HYPHENSTR = new String(new char[]{'\u00ad'});
    private static final char auml = '\u00e4';
    private static final char Auml = '\u00c4';
    private static final char ouml = '\u00f6';
    private static final char Ouml = '\u00d6';
    private static final char aring = '\u00e5';
    private static final char Aring = '\u00c5';
    private static final char scaron = '\u0161';
    private static final char Scaron = '\u0160';
    private static final char zcaron = '\u017e';
    private static final char Zcaron = '\u017d';
    private static final char[] FINNCHARS = new char[]{'a', 'A', 'b', 'B', 'c', 'C', 'd', 'D', 'e', 'E', 'f', 'F', 'g', 'G', 'h', 'H', 'i', 'I', 'j', 'J', 'k', 'K', 'l', 'L', 'm', 'M', 'n', 'N', 'o', 'O', 'p', 'P', 'q', 'Q', 'r', 'R', 's', 'S', '\u0161', '\u0160', 't', 'T', 'u', 'U', 'v', 'V', 'w', 'W', 'x', 'X', 'y', 'Y', 'z', 'Z', '\u017e', '\u017d', '\u00e5', '\u00c5', '\u00e4', '\u00c4', '\u00f6', '\u00d6'};
    private static final String FINNSTRING = new String(FINNCHARS);
    private static final Pattern FINNWORD = Pattern.compile("[" + FINNSTRING + "]+");
    private static final Pattern WS = Pattern.compile("\\p{javaWhitespace}+");
    private static final Map<String, String> map = new HashMap<String, String>();

    public static final String hyphenate(String text) {
        return Hyphenator.hyphenate(text, Locale.getDefault());
    }

    public static final String hyphenate(String text, Locale locale) {
        text = text.replace(HYPHENSTR, "");
        if (!"fi".equals(locale.getLanguage())) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        StringParser parser = new StringParser(text);
        while (parser.find(FINNWORD)) {
            sb.append(parser.skipped());
            Hyphenator.hyphenateWord(parser.group(), sb);
        }
        sb.append(parser.remaining());
        return sb.toString();
    }

    private static final void hyphenateWord(String word, StringBuilder sb) {
        Matcher mm = FINNWORD.matcher(word);
        if (mm.matches()) {
            if (map.containsKey(word.toLowerCase())) {
                String str = map.get(word.toLowerCase());
                int jj = 0;
                for (int ii = 0; ii < word.length(); ++ii) {
                    if (str.charAt(jj) == '\u00ad') {
                        sb.append('\u00ad');
                        ++jj;
                    }
                    ++jj;
                    sb.append(word.charAt(ii));
                }
            } else {
                State state = State.START;
                block7: for (int ii = 0; ii < word.length(); ++ii) {
                    char cc = word.charAt(ii);
                    switch (state) {
                        case VOCAL: {
                            sb.append('\u00ad');
                            sb.append(cc);
                            String sub = word.substring(ii);
                            state = Hyphenator.nextState(cc, sub);
                            continue block7;
                        }
                        case DIPHTHONG: {
                            sb.append(cc);
                            sb.append('\u00ad');
                            state = State.START;
                            continue block7;
                        }
                        case CONSONANT: {
                            String sub;
                            if (Hyphenator.vocal(cc)) {
                                sb.insert(sb.length() - 1, '\u00ad');
                                sb.append(cc);
                                sub = word.substring(ii);
                                state = Hyphenator.nextState(cc, sub);
                                continue block7;
                            }
                            sb.append(cc);
                            continue block7;
                        }
                        case START: {
                            String sub = word.substring(ii);
                            state = Hyphenator.nextState(cc, sub);
                            sb.append(cc);
                        }
                    }
                }
            }
        } else {
            sb.append(word);
        }
    }

    private static final State nextState(char cc, String sub) {
        if (Hyphenator.vocal(cc)) {
            if (Hyphenator.consonantRule(sub)) {
                return State.CONSONANT;
            }
            if (Hyphenator.vocalRule(sub)) {
                return State.VOCAL;
            }
            if (Hyphenator.diphthongRule(sub)) {
                return State.DIPHTHONG;
            }
        }
        return State.START;
    }

    private static final boolean consonantRule(String word) {
        char c1;
        if (word.length() > 1 && !Hyphenator.vocal(c1 = word.charAt(1))) {
            for (int ii = 2; ii < word.length(); ++ii) {
                char c2 = word.charAt(ii);
                if (!Hyphenator.vocal(c2)) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean vocalRule(String word) {
        if (word.length() > 1 && Hyphenator.vocal(word.charAt(1))) {
            char c1 = word.charAt(0);
            char c2 = word.charAt(1);
            return (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2)) && c2 != 'i' && !Hyphenator.diphthong(c1, c2);
        }
        return false;
    }

    private static final boolean diphthongRule(String word) {
        if (word.length() > 2) {
            char c1 = word.charAt(0);
            char c2 = word.charAt(1);
            char c3 = word.charAt(2);
            c1 = Character.toLowerCase(c1);
            c2 = Character.toLowerCase(c2);
            c3 = Character.toLowerCase(c3);
            if (Hyphenator.vocal(c1) && Hyphenator.vocal(c2) && Hyphenator.vocal(c3)) {
                return c1 == c2 || Hyphenator.diphthong(c1, c2);
            }
        }
        return false;
    }

    private static final boolean diphthong(char c1, char c2) {
        c1 = Character.toLowerCase(c1);
        c2 = Character.toLowerCase(c2);
        switch (c1) {
            case 'a': {
                return c2 == 'u';
            }
            case 'e': {
                return c2 == 'u' || c2 == 'y';
            }
            case 'i': {
                return c2 == 'e' || c2 == 'u';
            }
            case 'o': {
                return c2 == 'u';
            }
            case 'u': {
                return c2 == 'o';
            }
            case 'y': {
                return c2 == '\u00f6';
            }
            case '\u00e4': {
                return c2 == 'y';
            }
            case '\u00f6': {
                return c2 == 'y';
            }
        }
        return false;
    }

    private static final boolean vocal(char cc) {
        switch (Character.toLowerCase(cc)) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': 
            case 'y': 
            case '\u00e4': 
            case '\u00e5': 
            case '\u00f6': {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            System.err.println(Hyphenator.hyphenate("leffassa kivaa kahdelle"));
            System.err.println(Hyphenator.hyphenate("tragiikkaa sek\u00e4 horkkatiloja"));
            System.err.println(Hyphenator.hyphenate("luento Aasian k\u00e4\u00e4pi\u00f6puolueista"));
            System.err.println(Hyphenator.hyphenate("raaistunut maailma liuottimet lauantaina tauotta leuan alla"));
            System.err.println(Hyphenator.hyphenate("Kaivosaukko syysolkiperhonen"));
            System.err.println(Hyphenator.hyphenate("venemessuilla kisasuunnitelmia jutun sattuma huomattavasti"));
            System.err.println(Hyphenator.hyphenate("Deepawali, vapaap\u00e4iv\u00e4. ravintolassa: kunniaksi tekoon koristeitaan"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        map.put("kaivosaukko", "kai\u00advos\u00adauk\u00adko");
        map.put("syysolkiperhonen", "syys\u00adol\u00adki\u00adper\u00adho\u00adnen");
    }

    private static enum State {
        START,
        CONSONANT,
        VOCAL,
        DIPHTHONG;

    }
}

