/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.fi;

public class PankkiTiliNumero {
    private char[] _chk = new char[]{'2', '1', '2', '1', '2', '1', '2', '1', '2', '1', '2', '1', '2'};
    private char[] _buf = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};

    public PankkiTiliNumero(String bank, String account) throws NumberFormatException {
        this.init(bank, account);
    }

    public PankkiTiliNumero(int bank, int account) {
        this.init(bank, account);
    }

    public PankkiTiliNumero(String account) throws NumberFormatException {
        this.init(account);
    }

    private void init(String account) throws NumberFormatException {
        int idx = account.indexOf("-");
        if (idx == -1) {
            throw new IllegalArgumentException(account + " illegal format");
        }
        this.init(account.substring(0, idx), account.substring(idx + 1));
    }

    private void init(String bank, String account) throws NumberFormatException {
        int b = Integer.parseInt(bank);
        int a = Integer.parseInt(account);
        this.init(b, a);
    }

    private void init(int bank, int account) {
        boolean ii = false;
        String b = String.valueOf(bank);
        String a = String.valueOf(account);
        if (b.length() != 6) {
            throw new IllegalArgumentException(bank + " illegal length");
        }
        if (a.length() < 2) {
            throw new IllegalArgumentException(account + " too short");
        }
        if (a.length() > 8) {
            throw new IllegalArgumentException(account + " too long");
        }
        b.getChars(0, b.length(), this._buf, 0);
        if (b.startsWith("4") || b.startsWith("5")) {
            a.getChars(1, a.length(), this._buf, this._buf.length - a.length() + 1);
            a.getChars(0, 1, this._buf, 6);
        } else {
            a.getChars(0, a.length(), this._buf, this._buf.length - a.length());
        }
        this.checkDigit();
    }

    public void checkDigit() {
        int ii = 0;
        int chk = 0;
        int cd = 0;
        StringBuffer sb = new StringBuffer();
        for (ii = 0; ii < 13; ++ii) {
            sb.append((this._buf[ii] - 48) * (this._chk[ii] - 48));
        }
        for (ii = 0; ii < sb.length(); ++ii) {
            chk += sb.charAt(ii) - 48;
        }
        cd = (10 - chk % 10) % 10;
        if (cd != this._buf[13] - 48) {
            throw new IllegalArgumentException(this + " wrong check digit");
        }
    }

    public String toPankkiViivaKoodiString() {
        int ii = 0;
        StringBuffer sb = new StringBuffer();
        for (ii = 0; ii < 14; ++ii) {
            sb.append(this._buf[ii]);
        }
        return sb.toString();
    }

    public String toString() {
        int ii = 0;
        boolean zeros = false;
        StringBuffer sb = new StringBuffer();
        for (ii = 0; ii < 6; ++ii) {
            sb.append(this._buf[ii]);
        }
        sb.append("-");
        if (this._buf[0] == '4' || this._buf[0] == '5') {
            sb.append(this._buf[6]);
            for (ii = 7; ii < 14; ++ii) {
                if (this._buf[ii] == '0') {
                    if (!zeros) continue;
                    sb.append(this._buf[ii]);
                    continue;
                }
                sb.append(this._buf[ii]);
                zeros = true;
            }
        } else {
            for (ii = 6; ii < 14; ++ii) {
                if (this._buf[ii] == '0') {
                    if (!zeros) continue;
                    sb.append(this._buf[ii]);
                    continue;
                }
                sb.append(this._buf[ii]);
                zeros = true;
            }
        }
        return sb.toString();
    }

    public int fill(int start, char[] buf) {
        for (int ii = 0; ii < this._buf.length; ++ii) {
            buf[start + ii] = this._buf[ii];
        }
        return start + this._buf.length;
    }

    public static void main(String[] args) {
        try {
            PankkiTiliNumero ptn = new PankkiTiliNumero(args[0]);
            System.out.println(ptn + "  " + ptn.toPankkiViivaKoodiString());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

