/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.fi;

import java.util.Calendar;
import org.vesalainen.util.fi.PankkiTiliNumero;
import org.vesalainen.util.fi.ViiteNumero;

public class PankkiViivaKoodi {
    private char _versio = (char)49;
    private PankkiTiliNumero _tili = null;
    private int _sum = 0;
    private ViiteNumero _viite = null;
    private Calendar _due = null;

    public PankkiViivaKoodi(boolean euro, PankkiTiliNumero tili, double sum, ViiteNumero viite, Calendar due) {
        if (euro) {
            this._versio = (char)50;
        }
        this._tili = tili;
        this._sum = (int)(sum * 100.0);
        this._viite = viite;
        this._due = due;
    }

    public PankkiViivaKoodi(char versio, String tili, double sum, String viite, Calendar due) {
        if (versio != '1' && versio != '2') {
            throw new IllegalArgumentException("version " + versio + " is illegal");
        }
        this._versio = versio;
        this._tili = new PankkiTiliNumero(tili);
        this._sum = (int)(sum * 100.0);
        this._viite = new ViiteNumero(viite, false);
        this._due = due;
    }

    public String toString() {
        int[] chk = new int[]{3, 7, 1};
        int cd = 0;
        int ii = 0;
        int jj = 0;
        String sum = null;
        char[] buf = new char[54];
        for (ii = 0; ii < buf.length; ++ii) {
            buf[ii] = 48;
        }
        ii = 0;
        buf[ii++] = this._versio;
        ii = this._tili.fill(ii, buf);
        sum = String.valueOf(this._sum);
        sum.getChars(0, sum.length(), buf, ii + 8 - sum.length());
        ii += 8;
        ii = this._viite.fill(ii, buf);
        if (this._due != null) {
            sum = String.valueOf(this._due.get(1));
            sum.getChars(2, sum.length(), buf, ii);
            sum = String.valueOf(this._due.get(2) + 1);
            sum.getChars(0, sum.length(), buf, (ii += 2) + 2 - sum.length());
            sum = String.valueOf(this._due.get(5));
            sum.getChars(0, sum.length(), buf, (ii += 2) + 2 - sum.length());
            ii += 2;
        } else {
            ii += 6;
        }
        ii += 4;
        for (jj = 0; jj < 53; ++jj) {
            cd += (buf[jj] - 48) * chk[jj % 3];
        }
        buf[ii] = (char)(48 + (10 - cd % 10) % 10);
        return new String(buf);
    }

    public static void main(String[] args) {
        try {
            PankkiViivaKoodi pvk = new PankkiViivaKoodi('1', "227918-22392", 123456.78, "1", Calendar.getInstance());
            System.out.println(pvk);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

