/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.fi;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringParser {
    private static final Pattern ANY = Pattern.compile(".*");
    private List<MatchResult> stack = new ArrayList<MatchResult>();
    private CharSequence text;
    Matcher matcher;

    public StringParser(CharSequence text) {
        this.text = text;
        this.matcher = ANY.matcher(text);
    }

    public boolean find(Pattern pattern) {
        this.matcher.usePattern(pattern);
        int start = this.matcher.regionStart();
        if (this.matcher.find()) {
            this.stack.add(new MatchResultImpl(this.matcher));
            this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            return true;
        }
        return false;
    }

    public boolean lookingAt(Pattern pattern) {
        this.matcher.usePattern(pattern);
        if (this.matcher.lookingAt()) {
            this.stack.add(new MatchResultImpl(this.matcher));
            this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            return true;
        }
        return false;
    }

    public boolean matches(Pattern pattern) {
        this.matcher.usePattern(pattern);
        if (this.matcher.matches()) {
            this.stack.add(new MatchResultImpl(this.matcher));
            this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            return true;
        }
        return false;
    }

    public String skipped() {
        int start = 0;
        if (this.stack.size() > 1) {
            start = this.stack.get(this.stack.size() - 2).end();
        }
        int end = this.stack.get(this.stack.size() - 1).start();
        return this.text.subSequence(start, end).toString();
    }

    public String group() {
        return this.stack.get(this.stack.size() - 1).group();
    }

    public String group(int grp) {
        return this.stack.get(this.stack.size() - 1).group(grp);
    }

    public String remaining() {
        return this.text.subSequence(this.matcher.regionStart(), this.matcher.regionEnd()).toString();
    }

    public String toString() {
        return this.text.toString();
    }

    public class MatchResultImpl
    implements MatchResult {
        private String[] group;
        private int[] start;
        private int[] end;

        public MatchResultImpl(Matcher mm) {
            int count = mm.groupCount() + 1;
            this.group = new String[count];
            this.start = new int[count];
            this.end = new int[count];
            for (int ii = 0; ii < this.group.length; ++ii) {
                this.group[ii] = mm.group(ii);
                this.start[ii] = mm.start(ii);
                this.end[ii] = mm.end(ii);
            }
        }

        @Override
        public int start() {
            return this.start[0];
        }

        @Override
        public int start(int group) {
            return this.start[group];
        }

        @Override
        public int end() {
            return this.end[0];
        }

        @Override
        public int end(int group) {
            return this.end[group];
        }

        @Override
        public String group() {
            return this.group[0];
        }

        @Override
        public String group(int grp) {
            return this.group[grp];
        }

        @Override
        public int groupCount() {
            return this.group.length - 1;
        }
    }
}

