/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.fi;

public class ViiteNumero {
    private char[] _chk = new char[]{'7', '1', '3', '7', '1', '3', '7', '1', '3', '7', '1', '3', '7', '1', '3', '7', '1', '3', '7'};
    private char[] _buf = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};

    public ViiteNumero(String str, boolean check) {
        if (check ? str.length() > this._buf.length : str.length() > this._buf.length - 1) {
            throw new IllegalArgumentException(str + " is too long");
        }
        for (int ii = 0; ii < str.length(); ++ii) {
            if (str.charAt(ii) >= '0' && str.charAt(ii) <= '9') continue;
            throw new IllegalArgumentException(str + " contains non numeric characters");
        }
        if (check) {
            str.getChars(0, str.length(), this._buf, this._buf.length - str.length());
        } else {
            str.getChars(0, str.length(), this._buf, this._buf.length - 1 - str.length());
        }
        this.calcCheckDigit(check);
    }

    public ViiteNumero(long n, boolean check) {
        String str = String.valueOf(n);
        if (check) {
            str.getChars(0, str.length(), this._buf, this._buf.length - str.length());
        } else {
            str.getChars(0, str.length(), this._buf, this._buf.length - 1 - str.length());
        }
        this.calcCheckDigit(check);
    }

    private void calcCheckDigit(boolean check) {
        int chk = 0;
        for (int ii = 0; ii < this._buf.length - 1; ++ii) {
            chk += (this._chk[ii] - 48) * (this._buf[ii] - 48);
        }
        if (check) {
            if (this._buf[this._buf.length - 1] != (char)(48 + (char)((10 - chk % 10) % 10))) {
                throw new IllegalArgumentException(this + " has wrong check digit");
            }
        } else {
            this._buf[this._buf.length - 1] = (char)(48 + (char)((10 - chk % 10) % 10));
        }
    }

    public String toPankkiViivaKoodiString() {
        StringBuffer sb = new StringBuffer();
        for (int ii = 0; ii < this._buf.length; ++ii) {
            sb.append(this._buf[ii]);
        }
        return sb.toString();
    }

    public String toString() {
        boolean startzero = true;
        StringBuffer sb = new StringBuffer();
        for (int ii = 0; ii < this._buf.length; ++ii) {
            if (startzero) {
                if (this._buf[ii] == '0') continue;
                sb.append(this._buf[ii]);
                startzero = false;
                continue;
            }
            if (ii % 5 == 0) {
                sb.append(' ');
            }
            sb.append(this._buf[ii]);
        }
        return sb.toString();
    }

    public int fill(int start, char[] buf) {
        for (int ii = 0; ii < this._buf.length; ++ii) {
            buf[start + ii] = this._buf[ii];
        }
        return start + this._buf.length;
    }

    public static void main(String[] args) {
        try {
            ViiteNumero vn = new ViiteNumero(args[0], args.length > 1);
            System.out.println(vn);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

