/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.logging;

import java.util.List;
import java.util.logging.Level;

public abstract class BaseLogging {
    public void severe(String format, Object ... args) {
        if (this.isLoggable(Level.SEVERE)) {
            this.logIt(Level.SEVERE, String.format(format, args));
        }
    }

    public void warning(String format, Object ... args) {
        if (this.isLoggable(Level.WARNING)) {
            this.logIt(Level.WARNING, String.format(format, args));
        }
    }

    public void info(String format, Object ... args) {
        if (this.isLoggable(Level.INFO)) {
            this.logIt(Level.INFO, String.format(format, args));
        }
    }

    public void config(String format, Object ... args) {
        if (this.isLoggable(Level.CONFIG)) {
            this.logIt(Level.CONFIG, String.format(format, args));
        }
    }

    public void fine(String format, Object ... args) {
        if (this.isLoggable(Level.FINE)) {
            this.logIt(Level.FINE, String.format(format, args));
        }
    }

    public void finer(String format, Object ... args) {
        if (this.isLoggable(Level.FINER)) {
            this.logIt(Level.FINER, String.format(format, args));
        }
    }

    public void finest(String format, Object ... args) {
        if (this.isLoggable(Level.FINEST)) {
            this.logIt(Level.FINEST, String.format(format, args));
        }
    }

    public void log(Level level, String format, Object ... args) {
        if (this.isLoggable(level)) {
            if (format != null) {
                this.logIt(level, String.format(format, args));
            } else {
                this.logIt(level, String.format("%s format == null", level));
            }
        }
    }

    public void log(Level level, Throwable thrown, String format, Object ... args) {
        if (this.isLoggable(level)) {
            if (format != null) {
                this.logIt(level, String.format(format, args), thrown);
            } else {
                this.logIt(level, "", thrown);
            }
        }
    }

    public abstract List<String> getLoggerNames();

    public abstract boolean isLoggable(Level var1);

    protected abstract void logIt(Level var1, String var2);

    protected abstract void logIt(Level var1, String var2, Throwable var3);
}

