/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.navi;

import org.vesalainen.util.navi.Degree;
import org.vesalainen.util.navi.Scalar;
import org.vesalainen.util.navi.ScalarType;

public class Angle
extends Scalar {
    public static final Angle Right = new Degree(90);
    public static final Angle Straight = new Degree(180);
    public static final Angle North = new Degree(0);
    public static final Angle East = new Degree(90);
    public static final Angle South = new Degree(180);
    public static final Angle West = new Degree(270);
    public static final Angle NE = new Degree(45);
    public static final Angle SE = new Degree(135);
    public static final Angle NW = new Degree(315);
    public static final Angle SW = new Degree(225);
    public static final double FULL_CIRCLE = Math.PI * 2;

    public Angle(double radians) {
        super(Angle.normalizeToFullAngle(radians), ScalarType.ANGLE);
    }

    public Angle(double x, double y) {
        super(Angle.normalizeToFullAngle(Math.atan2(y, x)), ScalarType.ANGLE);
    }

    public Angle() {
        super(ScalarType.ANGLE);
    }

    public double getRadians() {
        return this.value;
    }

    public double getDegree() {
        return Math.toDegrees(this.value);
    }

    public Angle rightAngle() {
        return this.add(Right, false);
    }

    public Angle leftAngle() {
        return this.add(Right);
    }

    public Angle straightAngle() {
        return this.add(Straight);
    }

    public Angle halfAngle() {
        return new Angle(Angle.normalizeToHalfAngle(this.value));
    }

    public Angle add(Angle angle) {
        return this.add(angle, true);
    }

    public Angle add(Angle angle, boolean clockwice) {
        if (clockwice) {
            return new Angle(Angle.normalizeToFullAngle(this.value + angle.value));
        }
        return new Angle(Angle.normalizeToFullAngle(this.value - angle.value));
    }

    public Angle turn(Angle angle) {
        if (angle.getRadians() < Math.PI) {
            return this.add(angle, true);
        }
        return this.add(angle.toHalfAngle(), false);
    }

    public Angle toHalfAngle() {
        return new Angle(Angle.normalizeToHalfAngle(this.value));
    }

    public final boolean inSector(Angle start, Angle end) {
        if (start.clockwise(end)) {
            return !this.clockwise(start) && this.clockwise(end);
        }
        return this.clockwise(start) && !this.clockwise(end);
    }

    public static final Angle average(Angle ... angles) {
        double sin = 0.0;
        double cos = 0.0;
        for (Angle angle : angles) {
            sin += angle.sin();
            cos += angle.cos();
        }
        return new Angle(cos, sin);
    }

    public static final Angle difference(Angle a1, Angle a2) {
        return new Angle(Angle.normalizeToHalfAngle(Angle.angleDiff(a1.value, a2.value)));
    }

    public boolean equals(Angle angle, double maxDifference) {
        return Angle.angleDiff(this.value, angle.value) < maxDifference;
    }

    public final boolean clockwise(Angle angle) {
        return Angle.clockwise(this.value, angle.value);
    }

    public static final boolean clockwise(Angle angle1, Angle angle2) {
        return Angle.clockwise(angle1.value, angle2.value);
    }

    public static final boolean clockwise(double angle1, double angle2) {
        return Angle.angleDiff(angle1, angle2) >= 0.0;
    }

    public final double acos() {
        return Math.acos(this.value);
    }

    public final double asin() {
        return Math.asin(this.value);
    }

    public double atan() {
        return Math.atan(this.value);
    }

    public double cos() {
        return Math.cos(this.value);
    }

    public double cosh() {
        return Math.cosh(this.value);
    }

    public double sin() {
        return Math.sin(this.value);
    }

    public double sinh() {
        return Math.sinh(this.value);
    }

    @Override
    public String toString() {
        return Math.round(this.getDegree()) + "\u00b0";
    }

    public static final double normalizeToHalfAngle(double angle) {
        if ((angle = Angle.normalizeToFullAngle(angle)) > Math.PI) {
            return Math.PI * 2 - angle;
        }
        assert (angle >= 0.0 && angle <= Math.PI);
        return angle;
    }

    public static final double normalizeToFullAngle(double angle) {
        if (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        if (angle < 0.0) {
            angle = Math.PI * 2 + angle;
        }
        assert (angle >= 0.0 && angle <= Math.PI * 2);
        return angle;
    }

    public static final double signed(double angle) {
        if ((angle = Angle.normalizeToFullAngle(angle)) > Math.PI) {
            return angle - Math.PI * 2;
        }
        return angle;
    }

    public static final double angleDiff(double anAngle1, double anAngle2) {
        anAngle1 = Angle.normalizeToFullAngle(anAngle1);
        anAngle2 = Angle.normalizeToFullAngle(anAngle2);
        double angle = anAngle2 - anAngle1;
        angle = Angle.normalizeToFullAngle(angle);
        return Angle.signed(angle);
    }
}

