/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.navi;

import java.util.concurrent.TimeUnit;
import org.vesalainen.util.navi.Knots;
import org.vesalainen.util.navi.Scalar;
import org.vesalainen.util.navi.ScalarType;
import org.vesalainen.util.navi.TimeSpan;
import org.vesalainen.util.navi.Velocity;

public class Distance
extends Scalar {
    public Distance(double meters) {
        super(meters, ScalarType.DISTANCE);
    }

    public Velocity getSpeed(TimeSpan timeSpan) {
        return new Velocity(this, timeSpan);
    }

    public Velocity getHullSpeed() {
        return new Knots(1.34 * Math.sqrt(this.getFeets()));
    }

    public TimeSpan getTimeSpan(Velocity velocity) {
        return new TimeSpan(this.getMeters() / velocity.getMetersInSecond(), TimeUnit.SECONDS);
    }

    public double getMeters() {
        return this.value;
    }

    public double getMiles() {
        return this.value / 1852.0;
    }

    public double getFeets() {
        return this.value / 0.3048;
    }

    public double getFathoms() {
        return this.value / 1.8288;
    }

    @Override
    public String toString() {
        return this.getMeters() + "m";
    }
}

