/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.navi;

import org.vesalainen.util.navi.Location;
import org.vesalainen.util.navi.SimpleStats;

public class LocationStats {
    private SimpleStats x = new SimpleStats();
    private SimpleStats y = new SimpleStats();
    private int count;

    public LocationStats() {
    }

    public LocationStats(LocationStats a) {
        this.x = new SimpleStats(a.x);
        this.y = new SimpleStats(a.y);
    }

    public LocationStats(LocationStats a1, LocationStats a2) {
        this.x = new SimpleStats(a1.x, a2.x);
        this.y = new SimpleStats(a1.y, a2.y);
        this.count = a1.count + a2.count;
    }

    public void add(Location ... location) {
        for (Location l : location) {
            this.add(l);
        }
    }

    public void add(Location location) {
        this.x.add(location.getX());
        this.y.add(location.getY());
        ++this.count;
    }

    public Location getAverage() {
        return new Location(this.y.getAverage(), this.x.getAverage());
    }

    public double getDeviation() {
        return this.x.getDeviation() + this.y.getDeviation();
    }

    public void reset() {
        this.x.clear();
        this.y.clear();
        this.count = 0;
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        return this.getAverage().toString();
    }
}

