/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.navi;

import java.io.Serializable;
import org.vesalainen.util.navi.Angle;
import org.vesalainen.util.navi.Velocity;

public class Motion
implements Serializable {
    private static final long serialVersionUID = 2L;
    private Velocity speed;
    private Angle angle;

    public Motion() {
        this.speed = new Velocity();
        this.angle = new Angle();
    }

    public Motion(Velocity speed, Angle angle) {
        this.speed = speed;
        this.angle = angle;
    }

    public Motion(Velocity speed, Angle angle, boolean relative) {
        this.speed = speed;
        this.angle = angle;
        if (relative) {
            this.angle = this.angle.halfAngle();
        }
    }

    public Motion(Motion m1, Motion m2) {
        this.setXY(m1.getX() + m2.getX(), m1.getY() + m2.getY());
    }

    public Motion(Motion m1, Motion m2, boolean relative) {
        this.setXY(m1.getX() + m2.getX(), m1.getY() + m2.getY());
        if (relative) {
            this.angle = this.angle.halfAngle();
        }
    }

    public Motion turn(Angle angle, boolean clockwice) {
        return new Motion(this.speed, this.angle.add(angle, clockwice));
    }

    public Motion(double x, double y) {
        this.setXY(x, y);
    }

    protected void setXY(double x, double y) {
        this.speed = new Velocity(Math.sqrt(x * x + y * y));
        this.angle = new Angle(x, y);
    }

    protected double getX() {
        return this.cos() * this.speed.getValue();
    }

    protected double getY() {
        return this.sin() * this.speed.getValue();
    }

    public Motion getCounter() {
        return new Motion(this.speed, this.angle.straightAngle());
    }

    public Motion getRelative() {
        return new Motion(this.speed, this.angle.halfAngle());
    }

    public Velocity getSpeed() {
        return this.speed;
    }

    public Angle getAngle() {
        return this.angle;
    }

    public double getRadians() {
        return this.angle.getRadians();
    }

    public double getDegree() {
        return this.angle.getDegree();
    }

    public double getMetersInSecond() {
        return this.speed.getMetersInSecond();
    }

    public double getKiloMetersInHour() {
        return this.speed.getKiloMetersInHour();
    }

    public double getKnots() {
        return this.speed.getKnots();
    }

    public double cos() {
        return this.angle.cos();
    }

    public double sin() {
        return this.angle.sin();
    }

    public boolean equals(Object ob) {
        if (ob instanceof Motion) {
            Motion wind = (Motion)ob;
            return this.speed.equals(wind.speed) && this.angle.equals(wind.angle);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (this.speed != null ? this.speed.hashCode() : 0);
        hash = 71 * hash + (this.angle != null ? this.angle.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.speed + " " + this.angle;
    }
}

