/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.navi;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.vesalainen.util.navi.Distance;
import org.vesalainen.util.navi.Knots;
import org.vesalainen.util.navi.Scalar;
import org.vesalainen.util.navi.ScalarType;
import org.vesalainen.util.navi.TimeSpan;

public class Velocity
extends Scalar {
    public static final Velocity NaN = new Velocity(Double.NaN);
    private static final double HoursInSecondPerKilo = HoursInSecond / 1000.0;
    private static final double HoursInSecondPerNMInMeters = HoursInSecond / 1852.0;

    public Velocity(double metersInSecond) {
        super(metersInSecond, ScalarType.VELOCITY);
    }

    public Velocity(Distance distance, TimeSpan timeSpan) {
        super(distance.getMeters() / timeSpan.getSeconds(), ScalarType.VELOCITY);
    }

    public Velocity() {
        super(ScalarType.VELOCITY);
    }

    public Knots asKnots() {
        return new Knots(this.getKnots());
    }

    public Distance getDistance(TimeSpan timeSpan) {
        return new Distance(this.value * timeSpan.getSeconds());
    }

    public TimeSpan getTimeSpan(Distance distance) {
        return new TimeSpan((long)(1000.0 * distance.getMeters() / this.value), TimeUnit.MILLISECONDS);
    }

    public Date getThere(Date start, Distance distance) {
        TimeSpan timeSpan = this.getTimeSpan(distance);
        return timeSpan.addDate(start);
    }

    public double getMetersInSecond() {
        return this.value;
    }

    public double getKiloMetersInHour() {
        return Velocity.toKiloMetersInHour(this.value);
    }

    public double getKnots() {
        return Velocity.toKnots(this.value);
    }

    public static double toKiloMetersInHour(double metersPerSecond) {
        return HoursInSecondPerKilo * metersPerSecond;
    }

    public static double toKnots(double metersPerSecond) {
        return HoursInSecondPerNMInMeters * metersPerSecond;
    }

    @Override
    public String toString() {
        return String.format("%.1f m/s", this.getMetersInSecond());
    }
}

