/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.ViburDBCPException;
import org.vibur.dbcp.ViburDataSource;
import org.vibur.dbcp.ViburMonitoring;
import org.vibur.dbcp.cache.ClhmStatementCache;
import org.vibur.dbcp.pool.ConnHolder;
import org.vibur.dbcp.pool.ConnectionFactory;
import org.vibur.dbcp.pool.ViburObjectFactory;
import org.vibur.dbcp.proxy.ConnectionInvocationHandler;
import org.vibur.dbcp.util.JdbcUtils;
import org.vibur.dbcp.util.PoolOperations;
import org.vibur.dbcp.util.ViburUtils;
import org.vibur.objectpool.ConcurrentLinkedPool;
import org.vibur.objectpool.PoolObjectFactory;
import org.vibur.objectpool.PoolService;
import org.vibur.objectpool.util.ArgumentValidation;
import org.vibur.objectpool.util.Listener;
import org.vibur.objectpool.util.TakenListener;
import org.vibur.objectpool.util.ThreadedPoolReducer;

public class ViburDBCPDataSource
extends ViburConfig
implements ViburDataSource {
    private static final Logger logger = LoggerFactory.getLogger(ViburDBCPDataSource.class);
    private final AtomicReference<ViburDataSource.State> state = new AtomicReference<ViburDataSource.State>(ViburDataSource.State.NEW);
    private PoolOperations poolOperations;

    public ViburDBCPDataSource() {
    }

    public ViburDBCPDataSource(String configFileName) throws ViburDBCPException {
        URL config;
        if (configFileName != null) {
            config = this.getURL(configFileName);
            if (config == null) {
                throw new ViburDBCPException("Unable to load resource " + configFileName);
            }
        } else {
            config = this.getURL("vibur-dbcp-config.xml");
            if (config == null && (config = this.getURL("vibur-dbcp-config.properties")) == null) {
                throw new ViburDBCPException("Unable to load default resources from vibur-dbcp-config.xml or vibur-dbcp-config.properties");
            }
        }
        this.configureFromURL(config);
    }

    public ViburDBCPDataSource(Properties properties) throws ViburDBCPException {
        this.configureFromProperties(properties);
    }

    private URL getURL(String configFileName) {
        URL config = Thread.currentThread().getContextClassLoader().getResource(configFileName);
        if (config == null && (config = this.getClass().getClassLoader().getResource(configFileName)) == null) {
            config = ClassLoader.getSystemResource(configFileName);
        }
        return config;
    }

    private void configureFromURL(URL config) throws ViburDBCPException {
        InputStream inputStream = null;
        try {
            URLConnection uConn = config.openConnection();
            uConn.setUseCaches(false);
            inputStream = uConn.getInputStream();
            Properties properties = new Properties();
            if (config.getFile().endsWith(".xml")) {
                properties.loadFromXML(inputStream);
            } else {
                properties.load(inputStream);
            }
            this.configureFromProperties(properties);
        }
        catch (IOException e) {
            throw new ViburDBCPException(config.toString(), e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ignored) {
                    logger.debug("Couldn't close configuration URL {}", (Object)config, (Object)ignored);
                }
            }
        }
    }

    private void configureFromProperties(Properties properties) throws ViburDBCPException {
        HashSet<String> fields = new HashSet<String>();
        for (Field field : ViburConfig.class.getDeclaredFields()) {
            fields.add(field.getName());
        }
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            try {
                if (!fields.contains(key)) {
                    logger.warn("Unknown configuration property {}", (Object)key);
                    continue;
                }
                Field field = ViburConfig.class.getDeclaredField(key);
                Class<?> type = field.getType();
                if (type == Integer.TYPE || type == Integer.class) {
                    this.set(field, Integer.parseInt(val));
                    continue;
                }
                if (type == Long.TYPE || type == Long.class) {
                    this.set(field, Long.parseLong(val));
                    continue;
                }
                if (type == Float.TYPE || type == Float.class) {
                    this.set(field, Float.valueOf(Float.parseFloat(val)));
                    continue;
                }
                if (type == Boolean.TYPE || type == Boolean.class) {
                    this.set(field, Boolean.parseBoolean(val));
                    continue;
                }
                if (type == String.class) {
                    this.set(field, val);
                    continue;
                }
                throw new ViburDBCPException("Unexpected type for configuration property " + key);
            }
            catch (NumberFormatException | ReflectiveOperationException e) {
                throw new ViburDBCPException(String.format("Error setting configuration property %s, value = %s", key, val), e);
            }
        }
    }

    private void set(Field field, Object value) throws IllegalAccessException {
        field.setAccessible(true);
        field.set(this, value);
    }

    @Override
    public void start() throws ViburDBCPException {
        try {
            this.doStart();
        }
        catch (IllegalArgumentException | IllegalStateException | NullPointerException e) {
            throw new ViburDBCPException(e);
        }
    }

    private void doStart() throws ViburDBCPException {
        ConcurrentLinkedPool pool;
        if (!this.state.compareAndSet(ViburDataSource.State.NEW, ViburDataSource.State.WORKING)) {
            throw new IllegalStateException();
        }
        this.validateConfig();
        if (this.getExternalDataSource() == null) {
            this.initDriverAndProperties();
        }
        this.setConnector(this.buildConnector());
        ViburObjectFactory connectionFactory = this.getConnectionFactory();
        if (connectionFactory == null) {
            connectionFactory = new ConnectionFactory(this);
            this.setConnectionFactory(connectionFactory);
        }
        if ((pool = this.getPool()) == null) {
            pool = new ConcurrentLinkedPool((PoolObjectFactory)connectionFactory, this.getPoolInitialSize(), this.getPoolMaxSize(), this.isPoolFair(), (Listener)(this.isPoolEnableConnectionTracking() ? new TakenListener(this.getPoolInitialSize()) : null), this.isPoolFifo());
            this.setPool((PoolService<ConnHolder>)pool);
        }
        this.poolOperations = new PoolOperations(connectionFactory, (PoolService<ConnHolder>)pool, this);
        this.initPoolReducer();
        this.initStatementCache();
        if (this.isEnableJMX()) {
            ViburMonitoring.registerMBean(this);
        }
        logger.info("Started {}", (Object)this);
    }

    @Override
    public void terminate() {
        ViburDataSource.State oldState = this.state.getAndSet(ViburDataSource.State.TERMINATED);
        if (oldState == ViburDataSource.State.TERMINATED || oldState == ViburDataSource.State.NEW) {
            return;
        }
        if (this.getStatementCache() != null) {
            this.getStatementCache().close();
        }
        if (this.getPoolReducer() != null) {
            this.getPoolReducer().terminate();
        }
        if (this.getPool() != null) {
            this.getPool().terminate();
        }
        if (this.isEnableJMX()) {
            ViburMonitoring.unregisterMBean(this);
        }
        logger.info("Terminated {}", (Object)this);
    }

    @Override
    public void close() {
        this.terminate();
    }

    @Override
    public ViburDataSource.State getState() {
        return this.state.get();
    }

    private void validateConfig() {
        ArgumentValidation.forbidIllegalArgument((this.getExternalDataSource() == null && this.getJdbcUrl() == null ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getAcquireRetryDelayInMs() < 0L ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getAcquireRetryAttempts() < 0 ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getConnectionTimeoutInMs() < 0L ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getLoginTimeoutInSeconds() < 0 ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getStatementCacheMaxSize() < 0 && this.getStatementCache() == null ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getReducerTimeIntervalInSeconds() < 0 && this.getPoolReducer() == null ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getReducerTimeIntervalInSeconds() > 0 && this.getPoolReducerClass() == null && this.getPoolReducer() == null ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getReducerSamples() <= 0 ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getConnectionIdleLimitInSeconds() >= 0 && this.getTestConnectionQuery() == null ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.getValidateTimeoutInSeconds() < 0 ? 1 : 0) != 0);
        ArgumentValidation.forbidIllegalArgument((this.isUseNetworkTimeout() && this.getNetworkTimeoutExecutor() == null ? 1 : 0) != 0);
        Objects.requireNonNull(this.getCriticalSQLStates());
        Objects.requireNonNull(this.getViburLogger());
        if (this.getPassword() == null) {
            logger.warn("JDBC password is not specified.");
        }
        if (this.getUsername() == null) {
            logger.warn("JDBC username is not specified.");
        }
        if (this.getLogConnectionLongerThanMs() > this.getConnectionTimeoutInMs()) {
            logger.warn("Setting logConnectionLongerThanMs to {}", (Object)this.getConnectionTimeoutInMs());
            this.setLogConnectionLongerThanMs(this.getConnectionTimeoutInMs());
        }
        if (this.getStatementCacheMaxSize() > 2000) {
            logger.warn("Setting statementCacheMaxSize to {}", (Object)2000);
            this.setStatementCacheMaxSize(2000);
        }
        if (this.isLogTakenConnectionsOnTimeout() && !this.isPoolEnableConnectionTracking()) {
            logger.debug("Setting poolEnableConnectionTracking to true");
            this.setPoolEnableConnectionTracking(true);
        }
        if (this.getDefaultTransactionIsolation() != null) {
            String defaultTransactionIsolation;
            switch (defaultTransactionIsolation = this.getDefaultTransactionIsolation().toUpperCase()) {
                case "NONE": {
                    this.setDefaultTransactionIsolationValue(0);
                    break;
                }
                case "READ_COMMITTED": {
                    this.setDefaultTransactionIsolationValue(2);
                    break;
                }
                case "REPEATABLE_READ": {
                    this.setDefaultTransactionIsolationValue(4);
                    break;
                }
                case "READ_UNCOMMITTED": {
                    this.setDefaultTransactionIsolationValue(1);
                    break;
                }
                case "SERIALIZABLE": {
                    this.setDefaultTransactionIsolationValue(8);
                    break;
                }
                default: {
                    logger.warn("Unknown defaultTransactionIsolation {}. Will use the driver's default.", (Object)this.getDefaultTransactionIsolation());
                }
            }
        }
    }

    private void initDriverAndProperties() {
        Properties driverProperties;
        if (this.getDriver() == null) {
            try {
                if (this.getDriverClassName() != null) {
                    this.setDriver((Driver)Class.forName(this.getDriverClassName()).newInstance());
                } else {
                    this.setDriver(DriverManager.getDriver(this.getJdbcUrl()));
                }
            }
            catch (ClassCastException | ReflectiveOperationException | SQLException e) {
                throw new ViburDBCPException(e);
            }
        }
        if ((driverProperties = this.getDriverProperties()) == null) {
            driverProperties = new Properties();
            this.setDriverProperties(driverProperties);
        }
        driverProperties.setProperty("user", driverProperties.getProperty("user", this.getUsername()));
        driverProperties.setProperty("password", driverProperties.getProperty("password", this.getPassword()));
    }

    private JdbcUtils.Connector buildConnector() {
        if (this.getExternalDataSource() == null) {
            return new JdbcUtils.DriverConnector(this);
        }
        if (this.getUsername() != null) {
            return new JdbcUtils.DataSourceCredentialsConnector(this);
        }
        return new JdbcUtils.DataSourceDefaultConnector(this);
    }

    private void initPoolReducer() throws ViburDBCPException {
        ThreadedPoolReducer poolReducer = this.getPoolReducer();
        if (this.getReducerTimeIntervalInSeconds() > 0 && poolReducer == null) {
            try {
                poolReducer = (ThreadedPoolReducer)Class.forName(this.getPoolReducerClass()).getConstructor(ViburConfig.class).newInstance(this);
                this.setPoolReducer(poolReducer);
                poolReducer.start();
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                throw new ViburDBCPException(e);
            }
        }
    }

    private void initStatementCache() {
        int statementCacheMaxSize = this.getStatementCacheMaxSize();
        if (statementCacheMaxSize > 0 && this.getStatementCache() == null) {
            this.setStatementCache(new ClhmStatementCache(statementCacheMaxSize));
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        block4: {
            ViburDataSource.State state = this.validatePoolState(this.isAllowConnectionAfterTermination());
            if (state == ViburDataSource.State.WORKING) {
                try {
                    return this.getPooledConnection(this.getConnectionTimeoutInMs());
                }
                catch (SQLException e) {
                    if ("VI001".equals(e.getSQLState()) && this.isAllowConnectionAfterTermination()) break block4;
                    throw e;
                }
            }
        }
        assert (this.getState() == ViburDataSource.State.TERMINATED);
        logger.info("Calling getConnection() after the pool was closed; will create and return a non-pooled Connection.");
        return this.getNonPooledConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (this.defaultCredentials(username, password)) {
            return this.getConnection();
        }
        this.validatePoolState(this.isAllowConnectionAfterTermination());
        logger.warn("Calling getConnection() with different than the default credentials; will create and return a non-pooled Connection.");
        return this.getNonPooledConnection(username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getPooledConnection(long timeout) throws SQLException {
        boolean logSlowConn = this.getLogConnectionLongerThanMs() >= 0L;
        long startTime = logSlowConn ? System.currentTimeMillis() : 0L;
        Connection connProxy = null;
        try {
            Connection connection = connProxy = this.poolOperations.getProxyConnection(timeout);
            return connection;
        }
        finally {
            if (logSlowConn) {
                this.logGetConnection(timeout, startTime, connProxy);
            }
        }
    }

    @Override
    public Connection getNonPooledConnection() throws SQLException {
        return this.getNonPooledConnection(this.getUsername(), this.getPassword());
    }

    @Override
    public Connection getNonPooledConnection(String username, String password) throws SQLException {
        this.validatePoolState(true);
        try {
            return this.getConnectionFactory().create(username, password).value();
        }
        catch (ViburDBCPException e) {
            return ViburUtils.unwrapSQLException(e);
        }
    }

    @Override
    public void severConnection(Connection connection) throws SQLException {
        InvocationHandler ih;
        if (Proxy.isProxyClass(connection.getClass()) && (ih = Proxy.getInvocationHandler(connection)) instanceof ConnectionInvocationHandler) {
            ConnectionInvocationHandler cih = (ConnectionInvocationHandler)ih;
            cih.invalidate();
            return;
        }
        connection.close();
    }

    private ViburDataSource.State validatePoolState(boolean allowConnectionAfterTermination) throws SQLException {
        ViburDataSource.State state = this.getState();
        switch (state) {
            case NEW: {
                throw new SQLException(String.format("Pool %s, %s", new Object[]{this.getName(), state}), "VI000");
            }
            case WORKING: {
                return state;
            }
            case TERMINATED: {
                if (!allowConnectionAfterTermination) {
                    throw new SQLException(String.format("Pool %s, %s", new Object[]{this.getName(), state}), "VI001");
                }
                return state;
            }
        }
        throw new AssertionError((Object)state);
    }

    private boolean defaultCredentials(String username, String password) {
        if (this.getUsername() != null ? !this.getUsername().equals(username) : username != null) {
            return false;
        }
        return !(this.getPassword() == null ? password != null : !this.getPassword().equals(password));
    }

    private void logGetConnection(long timeout, long startTime, Connection connProxy) {
        long timeTaken = System.currentTimeMillis() - startTime;
        if (timeTaken >= this.getLogConnectionLongerThanMs()) {
            this.getViburLogger().logGetConnection(ViburUtils.getPoolName(this), connProxy, timeout, timeTaken, this.isLogStackTraceForLongConnection() ? new Throwable().getStackTrace() : null);
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.setLoginTimeoutInSeconds(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getLoginTimeoutInSeconds();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this.getExternalDataSource();
        }
        throw new SQLException("Not a wrapper for " + iface, "VI005");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return this.isAllowUnwrapping() && iface.isInstance(this.getExternalDataSource());
    }
}

