/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp;

import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.ViburMonitoringMBean;

public final class ViburMonitoring
implements ViburMonitoringMBean {
    private static final Logger logger = LoggerFactory.getLogger(ViburMonitoring.class);
    private final ViburConfig config;

    private ViburMonitoring(ViburConfig config) {
        this.config = config;
    }

    static void registerMBean(ViburConfig config) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(config.getJmxName());
            if (!mbs.isRegistered(objectName)) {
                mbs.registerMBean(new ViburMonitoring(config), objectName);
            } else {
                logger.warn(config.getJmxName() + " is already registered.");
            }
        }
        catch (JMException e) {
            logger.warn("Unable to register mBean {}", (Object)config.getJmxName(), (Object)e);
        }
    }

    static void unregisterMBean(ViburConfig config) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(config.getJmxName());
            if (mbs.isRegistered(objectName)) {
                mbs.unregisterMBean(objectName);
            } else {
                logger.warn(config.getJmxName() + " is not registered.");
            }
        }
        catch (JMException e) {
            logger.warn("Unable to unregister mBean {}", (Object)config.getJmxName(), (Object)e);
        }
    }

    @Override
    public String getJdbcUrl() {
        return this.config.getJdbcUrl();
    }

    @Override
    public String getDriverClassName() {
        return this.config.getDriverClassName();
    }

    @Override
    public int getConnectionIdleLimitInSeconds() {
        return this.config.getConnectionIdleLimitInSeconds();
    }

    @Override
    public void setConnectionIdleLimitInSeconds(int connectionIdleLimitInSeconds) {
        this.config.setConnectionIdleLimitInSeconds(connectionIdleLimitInSeconds);
    }

    @Override
    public int getValidateTimeoutInSeconds() {
        return this.config.getValidateTimeoutInSeconds();
    }

    @Override
    public void setValidateTimeoutInSeconds(int validateTimeoutInSeconds) {
        this.config.setValidateTimeoutInSeconds(validateTimeoutInSeconds);
    }

    @Override
    public String getTestConnectionQuery() {
        return this.config.getTestConnectionQuery();
    }

    @Override
    public void setTestConnectionQuery(String testConnectionQuery) {
        this.config.setTestConnectionQuery(testConnectionQuery);
    }

    @Override
    public String getInitSQL() {
        return this.config.getInitSQL();
    }

    @Override
    public void setInitSQL(String initSQL) {
        this.config.setInitSQL(initSQL);
    }

    @Override
    public boolean isUseNetworkTimeout() {
        return this.config.isUseNetworkTimeout();
    }

    @Override
    public int getPoolInitialSize() {
        return this.config.getPoolInitialSize();
    }

    @Override
    public int getPoolMaxSize() {
        return this.config.getPoolMaxSize();
    }

    @Override
    public int getPoolTaken() {
        return this.config.getPool().taken();
    }

    @Override
    public int getPoolRemainingCreated() {
        return this.config.getPool().remainingCreated();
    }

    @Override
    public boolean isPoolFair() {
        return this.config.isPoolFair();
    }

    @Override
    public boolean isPoolEnableConnectionTracking() {
        return this.config.isPoolEnableConnectionTracking();
    }

    @Override
    public int getReducerTimeIntervalInSeconds() {
        return this.config.getReducerTimeIntervalInSeconds();
    }

    @Override
    public int getReducerSamples() {
        return this.config.getReducerSamples();
    }

    @Override
    public boolean isAllowConnectionAfterTermination() {
        return this.config.isAllowConnectionAfterTermination();
    }

    @Override
    public boolean isAllowUnwrapping() {
        return this.config.isAllowUnwrapping();
    }

    @Override
    public long getConnectionTimeoutInMs() {
        return this.config.getConnectionTimeoutInMs();
    }

    @Override
    public void setConnectionTimeoutInMs(long connectionTimeoutInMs) {
        this.config.setConnectionTimeoutInMs(connectionTimeoutInMs);
    }

    @Override
    public int getLoginTimeoutInSeconds() {
        return this.config.getLoginTimeoutInSeconds();
    }

    @Override
    public void setLoginTimeoutInSeconds(int loginTimeoutInSeconds) {
        this.config.setLoginTimeoutInSeconds(loginTimeoutInSeconds);
    }

    @Override
    public long getAcquireRetryDelayInMs() {
        return this.config.getAcquireRetryDelayInMs();
    }

    @Override
    public void setAcquireRetryDelayInMs(long acquireRetryDelayInMs) {
        this.config.setAcquireRetryDelayInMs(acquireRetryDelayInMs);
    }

    @Override
    public int getAcquireRetryAttempts() {
        return this.config.getAcquireRetryAttempts();
    }

    @Override
    public void setAcquireRetryAttempts(int acquireRetryAttempts) {
        this.config.setAcquireRetryAttempts(acquireRetryAttempts);
    }

    @Override
    public int getStatementCacheMaxSize() {
        return this.config.getStatementCacheMaxSize();
    }

    @Override
    public long getLogConnectionLongerThanMs() {
        return this.config.getLogConnectionLongerThanMs();
    }

    @Override
    public void setLogConnectionLongerThanMs(long logConnectionLongerThanMs) {
        this.config.setLogConnectionLongerThanMs(logConnectionLongerThanMs);
    }

    @Override
    public boolean isLogStackTraceForLongConnection() {
        return this.config.isLogStackTraceForLongConnection();
    }

    @Override
    public void setLogStackTraceForLongConnection(boolean logStackTraceForLongConnection) {
        this.config.setLogStackTraceForLongConnection(logStackTraceForLongConnection);
    }

    @Override
    public long getLogQueryExecutionLongerThanMs() {
        return this.config.getLogQueryExecutionLongerThanMs();
    }

    @Override
    public void setLogQueryExecutionLongerThanMs(long logQueryExecutionLongerThanMs) {
        this.config.setLogQueryExecutionLongerThanMs(logQueryExecutionLongerThanMs);
    }

    @Override
    public boolean isLogStackTraceForLongQueryExecution() {
        return this.config.isLogStackTraceForLongQueryExecution();
    }

    @Override
    public void setLogStackTraceForLongQueryExecution(boolean logStackTraceForLongQueryExecution) {
        this.config.setLogStackTraceForLongQueryExecution(logStackTraceForLongQueryExecution);
    }

    @Override
    public long getLogLargeResultSet() {
        return this.config.getLogLargeResultSet();
    }

    @Override
    public void setLogLargeResultSet(long logLargeResultSet) {
        this.config.setLogLargeResultSet(logLargeResultSet);
    }

    @Override
    public boolean isLogStackTraceForLargeResultSet() {
        return this.config.isLogStackTraceForLargeResultSet();
    }

    @Override
    public void setLogStackTraceForLargeResultSet(boolean logStackTraceForLargeResultSet) {
        this.config.setLogStackTraceForLargeResultSet(logStackTraceForLargeResultSet);
    }

    @Override
    public boolean isIncludeQueryParameters() {
        return this.config.isIncludeQueryParameters();
    }

    @Override
    public void setIncludeQueryParameters(boolean includeQueryParameters) {
        this.config.setIncludeQueryParameters(includeQueryParameters);
    }

    @Override
    public boolean isLogTakenConnectionsOnTimeout() {
        return this.config.isLogTakenConnectionsOnTimeout();
    }

    @Override
    public boolean isResetDefaultsAfterUse() {
        return this.config.isResetDefaultsAfterUse();
    }

    @Override
    public Boolean getDefaultAutoCommit() {
        return this.config.getDefaultAutoCommit();
    }

    @Override
    public Boolean getDefaultReadOnly() {
        return this.config.getDefaultReadOnly();
    }

    @Override
    public String getDefaultTransactionIsolation() {
        return this.config.getDefaultTransactionIsolation();
    }

    @Override
    public String getDefaultCatalog() {
        return this.config.getDefaultCatalog();
    }

    @Override
    public boolean isClearSQLWarnings() {
        return this.config.isClearSQLWarnings();
    }

    @Override
    public String showTakenConnections() {
        return this.config.takenConnectionsToString();
    }
}

