/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.cache;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.cache.ConnMethod;
import org.vibur.dbcp.cache.StatementCache;
import org.vibur.dbcp.cache.StatementHolder;
import org.vibur.dbcp.proxy.TargetInvoker;
import org.vibur.dbcp.util.JdbcUtils;
import org.vibur.objectpool.util.ArgumentValidation;

public class ClhmStatementCache
implements StatementCache {
    private static final Logger logger = LoggerFactory.getLogger(ClhmStatementCache.class);
    private final ConcurrentMap<ConnMethod, StatementHolder> statementCache;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public ClhmStatementCache(int maxSize) {
        ArgumentValidation.forbidIllegalArgument((maxSize <= 0 ? 1 : 0) != 0);
        this.statementCache = Objects.requireNonNull(this.buildStatementCache(maxSize));
    }

    protected ConcurrentMap<ConnMethod, StatementHolder> buildStatementCache(int maxSize) {
        return new ConcurrentLinkedHashMap.Builder().initialCapacity(maxSize).maximumWeightedCapacity((long)maxSize).listener(this.getListener()).build();
    }

    private EvictionListener<ConnMethod, StatementHolder> getListener() {
        return new EvictionListener<ConnMethod, StatementHolder>(){

            public void onEviction(ConnMethod key, StatementHolder value) {
                if (value.state().getAndSet(StatementHolder.State.EVICTED) == StatementHolder.State.AVAILABLE) {
                    JdbcUtils.quietClose(value.value());
                }
                logger.trace("Evicted {}", (Object)value.value());
            }
        };
    }

    @Override
    public StatementHolder take(ConnMethod key, TargetInvoker invoker) throws Throwable {
        if (this.isClosed()) {
            return null;
        }
        StatementHolder statement = (StatementHolder)this.statementCache.get(key);
        if (statement != null && statement.state().compareAndSet(StatementHolder.State.AVAILABLE, StatementHolder.State.IN_USE)) {
            logger.trace("Using cached statement for {}", (Object)key);
            return statement;
        }
        Statement rawStatement = (Statement)invoker.targetInvoke(key.getMethod(), key.getArgs());
        if (statement == null && this.statementCache.putIfAbsent(key, statement = new StatementHolder(rawStatement, new AtomicReference<StatementHolder.State>(StatementHolder.State.IN_USE))) == null) {
            return statement;
        }
        return new StatementHolder(rawStatement, null);
    }

    @Override
    public void restore(StatementHolder statement, boolean clearWarnings) {
        if (statement.state() == null) {
            return;
        }
        if (this.isClosed()) {
            this.remove(statement.value());
            statement.state().set(StatementHolder.State.EVICTED);
        }
        Statement rawStatement = statement.value();
        try {
            if (clearWarnings) {
                JdbcUtils.clearWarnings(rawStatement);
            }
            if (!statement.state().compareAndSet(StatementHolder.State.IN_USE, StatementHolder.State.AVAILABLE)) {
                JdbcUtils.quietClose(rawStatement);
            }
        }
        catch (SQLException e) {
            logger.debug("Couldn't clear warnings on {}", (Object)rawStatement, (Object)e);
            this.remove(rawStatement);
            JdbcUtils.quietClose(rawStatement);
            statement.state().set(StatementHolder.State.EVICTED);
        }
    }

    @Override
    public boolean remove(Statement rawStatement) {
        for (Map.Entry entry : this.statementCache.entrySet()) {
            StatementHolder value = (StatementHolder)entry.getValue();
            if (value.value() != rawStatement) continue;
            return this.statementCache.remove(entry.getKey(), value);
        }
        return false;
    }

    @Override
    public int removeAll(Connection rawConnection) {
        int removed = 0;
        for (Map.Entry entry : this.statementCache.entrySet()) {
            ConnMethod key = (ConnMethod)entry.getKey();
            StatementHolder value = (StatementHolder)entry.getValue();
            if (key.getTarget() != rawConnection || !this.statementCache.remove(key, value)) continue;
            JdbcUtils.quietClose(value.value());
            ++removed;
        }
        return removed;
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        for (Map.Entry entry : this.statementCache.entrySet()) {
            StatementHolder value = (StatementHolder)entry.getValue();
            this.statementCache.remove(entry.getKey(), value);
            JdbcUtils.quietClose(value.value());
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }
}

