/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.ViburDBCPException;
import org.vibur.dbcp.event.InvocationHook;
import org.vibur.dbcp.proxy.ExceptionCollector;
import org.vibur.dbcp.proxy.TargetInvoker;
import org.vibur.dbcp.util.ViburUtils;

abstract class AbstractInvocationHandler<T>
implements InvocationHandler,
TargetInvoker {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInvocationHandler.class);
    private static final Object NO_RESULT = new Object();
    private final T target;
    private final InvocationHook invocationHook;
    private final ViburConfig config;
    private final ExceptionCollector exceptionCollector;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    AbstractInvocationHandler(T target, ViburConfig config, ExceptionCollector exceptionCollector) {
        assert (target != null);
        assert (config != null);
        assert (exceptionCollector != null);
        this.target = target;
        this.invocationHook = config.getInvocationHook();
        this.config = config;
        this.exceptionCollector = exceptionCollector;
    }

    @Override
    public final Object invoke(Object objProxy, Method method, Object[] args) throws Throwable {
        Object proxy;
        Object unrestrictedResult;
        if (logger.isTraceEnabled()) {
            logger.trace("Calling {} with args {} on {}", new Object[]{method, Arrays.toString(args), this.target});
        }
        if ((unrestrictedResult = this.unrestrictedInvoke(proxy = objProxy, method, args)) != NO_RESULT) {
            return unrestrictedResult;
        }
        this.restrictedAccessEntry(proxy, method, args);
        try {
            return this.restrictedInvoke(proxy, method, args);
        }
        catch (ViburDBCPException e) {
            logger.error("Pool {}, the invocation of {} with args {} on {} threw:", new Object[]{ViburUtils.getPoolName(this.config), method, Arrays.toString(args), this.target, e});
            Throwable cause = e.getCause();
            if (cause instanceof SQLException) {
                throw cause;
            }
            throw e;
        }
    }

    Object unrestrictedInvoke(T proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName == "equals") {
            return proxy == args[0];
        }
        if (methodName == "hashCode") {
            return System.identityHashCode(proxy);
        }
        if (methodName == "toString") {
            return "Vibur proxy for: " + this.target;
        }
        if (methodName == "unwrap") {
            Class iface = (Class)args[0];
            return this.unwrap(iface);
        }
        if (methodName == "isWrapperFor") {
            return this.isWrapperFor((Class)args[0]);
        }
        return NO_RESULT;
    }

    private void restrictedAccessEntry(T proxy, Method method, Object[] args) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(this.target.getClass().getName() + " is closed.", "VI004");
        }
        if (this.invocationHook != null) {
            this.invocationHook.invoke(proxy, method, args);
        }
    }

    Object restrictedInvoke(T proxy, Method method, Object[] args) throws Throwable {
        return this.targetInvoke(method, args);
    }

    @Override
    public final Object targetInvoke(Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.target, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            this.logTargetInvokeFailure(method, args, cause);
            this.exceptionCollector.addException(cause);
            if (cause instanceof SQLException || cause instanceof RuntimeException || cause instanceof Error) {
                throw cause;
            }
            throw new ViburDBCPException(cause);
        }
    }

    void logTargetInvokeFailure(Method method, Object[] args, Throwable t) {
        if (logger.isDebugEnabled()) {
            logger.debug("Pool {}, the invocation of {} with args {} on {} threw:", new Object[]{ViburUtils.getPoolName(this.config), method, Arrays.toString(args), this.target, t});
        }
    }

    final boolean close() {
        return !this.closed.getAndSet(true);
    }

    final boolean isClosed() {
        return this.closed.get();
    }

    final ExceptionCollector getExceptionCollector() {
        return this.exceptionCollector;
    }

    final T getTarget() {
        return this.target;
    }

    private T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return this.target;
        }
        throw new SQLException("Not a wrapper for " + iface, "VI005");
    }

    private boolean isWrapperFor(Class<?> iface) {
        return this.config.isAllowUnwrapping() && iface.isInstance(this.target);
    }
}

