/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.proxy;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Statement;
import org.vibur.dbcp.ViburConfig;
import org.vibur.dbcp.cache.ConnMethod;
import org.vibur.dbcp.cache.StatementCache;
import org.vibur.dbcp.cache.StatementHolder;
import org.vibur.dbcp.pool.ConnHolder;
import org.vibur.dbcp.proxy.AbstractInvocationHandler;
import org.vibur.dbcp.proxy.ExceptionCollector;
import org.vibur.dbcp.proxy.Proxy;
import org.vibur.dbcp.util.PoolOperations;

public class ConnectionInvocationHandler
extends AbstractInvocationHandler<Connection> {
    private final ConnHolder conn;
    private final PoolOperations poolOperations;
    private final StatementCache statementCache;
    private final ViburConfig config;

    ConnectionInvocationHandler(ConnHolder conn, PoolOperations poolOperations, ViburConfig config) {
        super(conn.value(), config, new ExceptionCollector(config));
        this.conn = conn;
        this.poolOperations = poolOperations;
        this.statementCache = config.getStatementCache();
        this.config = config;
    }

    @Override
    Object unrestrictedInvoke(Connection proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName == "close") {
            return this.processClose();
        }
        if (methodName == "isClosed") {
            return this.isClosed();
        }
        if (methodName == "isValid") {
            return this.isClosed() ? Boolean.valueOf(false) : this.targetInvoke(method, args);
        }
        if (methodName == "abort") {
            return this.processAbort(method, args);
        }
        return super.unrestrictedInvoke(proxy, method, args);
    }

    @Override
    Object restrictedInvoke(Connection proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName == "createStatement") {
            StatementHolder statement = this.getUncachedStatement(method, args);
            return Proxy.newProxyStatement(statement, proxy, this.config, this.getExceptionCollector());
        }
        if (methodName == "prepareStatement") {
            StatementHolder pStatement = this.getCachedStatement(method, args);
            return Proxy.newProxyPreparedStatement(pStatement, proxy, this.config, this.getExceptionCollector());
        }
        if (methodName == "prepareCall") {
            StatementHolder cStatement = this.getCachedStatement(method, args);
            return Proxy.newProxyCallableStatement(cStatement, proxy, this.config, this.getExceptionCollector());
        }
        if (methodName == "getMetaData") {
            DatabaseMetaData rawDatabaseMetaData = (DatabaseMetaData)this.targetInvoke(method, args);
            return Proxy.newProxyDatabaseMetaData(rawDatabaseMetaData, proxy, this.config, this.getExceptionCollector());
        }
        return super.restrictedInvoke(proxy, method, args);
    }

    private StatementHolder getCachedStatement(Method method, Object[] args) throws Throwable {
        if (this.statementCache != null) {
            return this.statementCache.take(new ConnMethod((Connection)this.getTarget(), method, args), this);
        }
        return this.getUncachedStatement(method, args);
    }

    private StatementHolder getUncachedStatement(Method method, Object[] args) throws Throwable {
        Statement rawStatement = (Statement)this.targetInvoke(method, args);
        return new StatementHolder(rawStatement, null);
    }

    private Object processClose() {
        if (this.close()) {
            this.poolOperations.restore(this.conn, true, this.getExceptionCollector().getExceptions());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processAbort(Method method, Object[] args) throws Throwable {
        if (!this.close()) {
            return null;
        }
        try {
            Object object = this.targetInvoke(method, args);
            return object;
        }
        finally {
            this.poolOperations.restore(this.conn, false, this.getExceptionCollector().getExceptions());
        }
    }

    public void invalidate() {
        if (this.close()) {
            this.poolOperations.restore(this.conn, false, this.getExceptionCollector().getExceptions());
        }
    }
}

